/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.util;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.jwebsocket.api.WebSocketClientEvent;
import org.jwebsocket.api.WebSocketClientListener;
import org.jwebsocket.api.WebSocketPacket;
import to.sparks.mtgox.MtGoxRealTime;
import to.sparks.mtgox.dto.Depth;
import to.sparks.mtgox.dto.DynaBean;
import to.sparks.mtgox.dto.OpPrivateDepth;
import to.sparks.mtgox.dto.OpPrivateTicker;

public class MtGoxSocket
implements WebSocketClientListener {
    private MtGoxRealTime apiClient;
    private Logger logger;

    public MtGoxSocket(MtGoxRealTime apiClient, Logger logger) {
        this.apiClient = apiClient;
        this.logger = logger;
    }

    public void processOpened(WebSocketClientEvent aEvent) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processPacket(WebSocketClientEvent aEvent, WebSocketPacket aPacket) {
        if (aEvent == null) throw new UnsupportedOperationException("Not supported yet.");
        if (aPacket == null || aPacket.getFrameType() != 0) throw new UnsupportedOperationException("Not supported yet.");
        try {
            JsonFactory factory = new JsonFactory();
            ObjectMapper mapper = new ObjectMapper();
            JsonParser jp = factory.createJsonParser(aPacket.getUTF8());
            DynaBean op = (DynaBean)mapper.readValue(jp, DynaBean.class);
            if (op.get("op") != null && op.get("op").equals("private")) {
                String messageType = op.get("private").toString();
                if (messageType.equalsIgnoreCase("ticker")) {
                    OpPrivateTicker opPrivateTicker = (OpPrivateTicker)mapper.readValue(factory.createJsonParser(aPacket.getUTF8()), OpPrivateTicker.class);
                    this.apiClient.tickerEvent(opPrivateTicker.getTicker());
                    return;
                } else if (messageType.equalsIgnoreCase("depth")) {
                    OpPrivateDepth opPrivateDepth = (OpPrivateDepth)mapper.readValue(factory.createJsonParser(aPacket.getUTF8()), OpPrivateDepth.class);
                    Depth depth = opPrivateDepth.getDepth();
                    this.apiClient.depthEvent(depth);
                    return;
                } else {
                    this.logger.log(Level.INFO, "Unknown private operation: {0}", new Object[]{aPacket.getUTF8()});
                }
                return;
            }
            this.logger.log(Level.INFO, "Unknown operation: {0}, payload: {1}", new Object[]{op.get("op")});
            return;
        }
        catch (IOException ex) {
            this.logger.log(Level.SEVERE, null, ex);
        }
    }

    public void processClosed(WebSocketClientEvent aEvent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

