/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jwebsocket.api.WebSocketClientListener;
import org.jwebsocket.client.java.BaseWebSocket;
import org.jwebsocket.kit.WebSocketException;
import to.sparks.mtgox.dto.Depth;
import to.sparks.mtgox.dto.FullDepth;
import to.sparks.mtgox.dto.Offer;
import to.sparks.mtgox.dto.Ticker;
import to.sparks.mtgox.impl.MtGoxApiImpl;
import to.sparks.mtgox.util.MtGoxListener;
import to.sparks.mtgox.util.MtGoxSocket;

public class MtGoxRealTime
implements MtGoxListener {
    private static final Logger logger = Logger.getLogger(MtGoxRealTime.class.getName());
    private List<Depth> depthHistory = new CopyOnWriteArrayList<Depth>();
    private List<Ticker> tickerHistory = new CopyOnWriteArrayList<Ticker>();
    private List<Offer> asks;
    private List<Offer> bids;
    private long mostRecentAskTimestamp;
    private long mostRecentBidTimestamp;
    private long mostRecentTimestamp;
    final BaseWebSocket websocket = new BaseWebSocket();

    public MtGoxRealTime(FullDepth fullDepth) throws WebSocketException, IOException {
        this.websocket.addListener((WebSocketClientListener)new MtGoxSocket(this, logger));
        this.websocket.open("ws://websocket.mtgox.com/mtgox");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("Closing connection...");
                try {
                    MtGoxRealTime.this.websocket.close();
                }
                catch (WebSocketException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        });
        this.asks = new ArrayList<Offer>(Arrays.asList(fullDepth.getAsks()));
        this.bids = new ArrayList<Offer>(Arrays.asList(fullDepth.getBids()));
        this.mostRecentAskTimestamp = MtGoxRealTime.getMostRecentTimestamp(this.asks);
        this.mostRecentBidTimestamp = MtGoxRealTime.getMostRecentTimestamp(this.bids);
        this.mostRecentTimestamp = this.mostRecentAskTimestamp < this.mostRecentBidTimestamp ? this.mostRecentBidTimestamp : this.mostRecentAskTimestamp;
    }

    public List<Depth> getAllDepthSince(long timestamp) {
        List<Depth> result = new ArrayList<Depth>();
        int length = this.depthHistory.size();
        for (int i = 0; i < length; ++i) {
            Depth depth = this.depthHistory.get(i);
            if (depth.getStamp() <= timestamp) continue;
            result = this.depthHistory.subList(i, length - 1);
            break;
        }
        return result;
    }

    @Override
    public void tickerEvent(Ticker ticker) {
        this.tickerHistory.add(ticker);
    }

    @Override
    public void depthEvent(Depth depth) {
        this.depthHistory.add(depth);
        List<Depth> updates = this.getAllDepthSince(this.mostRecentTimestamp);
        for (Depth update : updates) {
            double multiplier;
            if (update.getStamp() < this.mostRecentTimestamp) {
                logger.log(Level.WARNING, "Warning:  Out of order timestamp found. {0} < {1}", new Object[]{update.getStamp(), this.mostRecentTimestamp});
                continue;
            }
            List<Offer> offers = update.getType_str().equalsIgnoreCase("ASK") ? this.asks : this.bids;
            this.mostRecentTimestamp = update.getStamp();
            switch (update.getCurrency().toLowerCase()) {
                case "aud": {
                    multiplier = MtGoxApiImpl.AUD_INT_MULTIPLIER;
                    break;
                }
                default: {
                    multiplier = MtGoxApiImpl.USD_INT_MULTIPLIER;
                }
            }
            MtGoxRealTime.updateDepth(update, offers, multiplier);
        }
        logger.log(Level.INFO, "Asks: {0}  Bids: {1}", new Object[]{this.asks.size(), this.bids.size()});
    }

    private static void updateDepth(Depth update, List<Offer> depth, double covertToIntFactor) {
        ArrayList<Offer> emptyOffers = new ArrayList<Offer>();
        for (Offer offer : depth) {
            if (offer.getAmount_int() == 0L) {
                emptyOffers.add(offer);
            }
            if (offer.getPrice_int() != update.getPrice_int()) continue;
            double dAmount = (double)update.getTotal_volume_int() / covertToIntFactor;
            logger.log(Level.INFO, "Update at price {0}   Old volume: {1}  New volume: {2}", new Object[]{offer.getPrice(), offer.getAmount(), dAmount});
            offer.setAmount_int(update.getTotal_volume_int());
            offer.setAmount(dAmount);
            offer.setStamp(update.getStamp());
            break;
        }
        if (update.getAmount_int() > 0L) {
            logger.log(Level.INFO, "New offer at price {0}   volume: {1}  (total {2})", new Object[]{update.getPrice(), update.getAmount(), update.getTotal_volume_int()});
            Offer offer = new Offer(update.getPrice(), update.getAmount(), update.getPrice_int(), update.getAmount_int(), update.getStamp());
            depth.add(offer);
        }
        for (Offer offer : emptyOffers) {
            depth.remove(offer);
        }
    }

    private static long getMostRecentTimestamp(List<Offer> offers) {
        long mostRecentTimestamp = 0L;
        for (Offer offer : offers) {
            if (offer.getStamp() <= mostRecentTimestamp) continue;
            mostRecentTimestamp = offer.getStamp();
        }
        return mostRecentTimestamp;
    }

    public List<Depth> getDepthHistory() {
        return this.depthHistory;
    }

    public List<Ticker> getTickerHistory() {
        return this.tickerHistory;
    }

    public List<Offer> getAsks() {
        return this.asks;
    }

    public List<Offer> getBids() {
        return this.bids;
    }
}

