/*
 * Decompiled with CFR 0.152.
 */
package to.sparks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import to.sparks.mtgox.MtGoxAPI;
import to.sparks.mtgox.model.Depth;
import to.sparks.mtgox.model.FullDepth;
import to.sparks.mtgox.model.Offer;
import to.sparks.mtgox.model.Ticker;
import to.sparks.mtgox.service.MtGoxHTTPClient;
import to.sparks.mtgox.service.MtGoxServiceImpl;
import to.sparks.mtgox.service.MtGoxWebSocketClient;

public class MtGoxExample {
    static final Logger logger = Logger.getLogger(MtGoxExample.class.getName());

    public static void main(String[] args) throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("to/sparks/Beans.xml");
        MtGoxAPI mtgoxUSD = (MtGoxAPI)context.getBean("mtgoxUSD");
        Ticker ticker = mtgoxUSD.getTicker();
        logger.log(Level.INFO, "Last price: {0}", ticker.getLast().getValue());
        logger.info("Downloading fulldepth...");
        MtGoxHTTPClient httpAPI = (MtGoxHTTPClient)context.getBean("httpApi");
        Currency currency = (Currency)context.getBean("usdCurrency");
        FullDepth fullDepth = httpAPI.getFullDepth(currency);
        ArrayList<Offer> asks = new ArrayList<Offer>(Arrays.asList(fullDepth.getAsks()));
        ArrayList<Offer> bids = new ArrayList<Offer>(Arrays.asList(fullDepth.getBids()));
        long mostRecentAskTimestamp = MtGoxExample.getMostRecentTimestamp(asks);
        long mostRecentBidTimestamp = MtGoxExample.getMostRecentTimestamp(bids);
        long mostRecentTimestamp = mostRecentAskTimestamp < mostRecentBidTimestamp ? mostRecentBidTimestamp : mostRecentAskTimestamp;
        MtGoxWebSocketClient wsAPI = (MtGoxWebSocketClient)context.getBean("wsApi");
        List<Depth> updates = wsAPI.getAllDepthSince(mostRecentTimestamp);
        for (Depth update : updates) {
            double multiplier;
            if (update.getStamp() < mostRecentTimestamp) {
                logger.log(Level.WARNING, "Warning:  Out of order timestamp found. {0} < {1}", new Object[]{update.getStamp(), mostRecentTimestamp});
                continue;
            }
            ArrayList<Offer> offers = update.getType_str().equalsIgnoreCase("ASK") ? asks : bids;
            mostRecentTimestamp = update.getStamp();
            switch (update.getCurrency().toLowerCase()) {
                case "aud": {
                    multiplier = MtGoxServiceImpl.AUD_INT_MULTIPLIER;
                    break;
                }
                default: {
                    multiplier = MtGoxServiceImpl.USD_INT_MULTIPLIER;
                }
            }
            MtGoxExample.updateDepth(update, offers, multiplier);
        }
        logger.log(Level.INFO, "Asks: {0}  Bids: {1}", new Object[]{asks != null ? Integer.valueOf(asks.size()) : "null", bids != null ? Integer.valueOf(bids.size()) : "null"});
    }

    private static long getMostRecentTimestamp(List<Offer> offers) {
        long mostRecentTimestamp = 0L;
        for (Offer offer : offers) {
            if (offer.getStamp() <= mostRecentTimestamp) continue;
            mostRecentTimestamp = offer.getStamp();
        }
        return mostRecentTimestamp;
    }

    private static void updateDepth(Depth update, List<Offer> depth, double covertToIntFactor) {
        ArrayList<Offer> emptyOffers = new ArrayList<Offer>();
        for (Offer offer : depth) {
            if (offer.getAmount_int() == 0L) {
                emptyOffers.add(offer);
            }
            if (offer.getPrice_int() != update.getPrice_int()) continue;
            double dAmount = (double)update.getTotal_volume_int() / covertToIntFactor;
            offer.setAmount_int(update.getTotal_volume_int());
            offer.setAmount(dAmount);
            offer.setStamp(update.getStamp());
            break;
        }
        if (update.getAmount_int() > 0L) {
            Offer offer = new Offer(update.getPrice(), update.getAmount(), update.getPrice_int(), update.getAmount_int(), update.getStamp());
            depth.add(offer);
        }
        for (Offer offer : emptyOffers) {
            depth.remove(offer);
        }
    }
}

