/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.service;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import to.sparks.mtgox.MtGoxAPI;
import to.sparks.mtgox.model.Depth;
import to.sparks.mtgox.model.FullDepth;
import to.sparks.mtgox.model.Order;
import to.sparks.mtgox.model.OrderResult;
import to.sparks.mtgox.model.Ticker;
import to.sparks.mtgox.service.MtGoxHTTPClient;
import to.sparks.mtgox.service.MtGoxWebSocketClient;

public class MtGoxServiceImpl
implements MtGoxAPI {
    public static double USD_INT_MULTIPLIER = 1.0E8;
    public static double AUD_INT_MULTIPLIER = 100000.0;
    public static double BTC_VOL_INT_MULTIPLIER = 1.0E8;
    private static Logger logger;
    private static MtGoxWebSocketClient wsApi;
    private Currency currency;
    MtGoxHTTPClient httpAPI;

    public MtGoxServiceImpl(Logger logger, MtGoxHTTPClient httpAPI, MtGoxWebSocketClient mtGoxWebSocketApi, Currency currency) {
        MtGoxServiceImpl.logger = logger;
        this.currency = currency;
        this.httpAPI = httpAPI;
        wsApi = mtGoxWebSocketApi;
    }

    @Override
    public List<Depth> getAllDepthSince(long timestamp) {
        return wsApi != null ? wsApi.getAllDepthSince(timestamp) : null;
    }

    @Override
    public List<Depth> getDepthHistory() {
        return wsApi != null ? wsApi.getDepthHistory() : null;
    }

    @Override
    public List<Ticker> getTickerHistory() {
        return wsApi != null ? wsApi.getTickerHistory() : null;
    }

    @Override
    public FullDepth getFullDepth() throws IOException, Exception {
        return this.httpAPI.getFullDepth(this.currency);
    }

    private static int convertVolumeBTCtoInt(double d) {
        double total = d * BTC_VOL_INT_MULTIPLIER;
        return (int)total;
    }

    private static int convertPricetoInt(String currencyCode, double d) {
        double multiplier;
        switch (currencyCode.toLowerCase()) {
            case "aud": {
                multiplier = AUD_INT_MULTIPLIER;
                break;
            }
            default: {
                multiplier = USD_INT_MULTIPLIER;
            }
        }
        double total = d * multiplier;
        return (int)total;
    }

    @Override
    public String placeOrder(MtGoxAPI.OrderType orderType, Double price, double volume) throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (orderType == MtGoxAPI.OrderType.Bid) {
            params.put("type", "bid");
        } else {
            params.put("type", "ask");
        }
        if (price != null) {
            params.put("price_int", String.valueOf(MtGoxServiceImpl.convertPricetoInt(this.currency.getCurrencyCode(), price)));
        }
        params.put("amount_int", String.valueOf(MtGoxServiceImpl.convertVolumeBTCtoInt(volume)));
        return this.httpAPI.placeOrder(this.currency, params);
    }

    @Override
    public String placeMarketOrder(MtGoxAPI.OrderType orderType, double volume) throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        return this.placeOrder(orderType, null, volume);
    }

    @Override
    public OrderResult getOrderResult(MtGoxAPI.OrderType orderType, String orderRef) throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (orderType == MtGoxAPI.OrderType.Bid) {
            params.put("type", "bid");
        } else {
            params.put("type", "ask");
        }
        params.put("order", orderRef);
        return this.httpAPI.getPrivateOrderResult(params);
    }

    @Override
    public Order[] getOpenOrders() throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        return this.httpAPI.getOpenOrders();
    }

    @Override
    public Ticker getTicker() throws IOException, Exception {
        return this.httpAPI.getTicker(this.currency);
    }
}

