/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jwebsocket.api.WebSocketClientListener;
import org.jwebsocket.client.java.BaseWebSocket;
import org.springframework.core.task.TaskExecutor;
import to.sparks.mtgox.model.Depth;
import to.sparks.mtgox.model.Ticker;
import to.sparks.mtgox.net.MtGoxListener;
import to.sparks.mtgox.net.MtGoxSocketListener;

public class MtGoxWebSocketClient
implements MtGoxListener,
Runnable {
    private Logger logger;
    private List<Depth> depthHistory = new CopyOnWriteArrayList<Depth>();
    private List<Ticker> tickerHistory = new CopyOnWriteArrayList<Ticker>();
    final BaseWebSocket websocket = new BaseWebSocket();
    private TaskExecutor taskExecutor;

    public MtGoxWebSocketClient(Logger logger, TaskExecutor taskExecutor) {
        this.logger = logger;
        this.taskExecutor = taskExecutor;
    }

    public void init() {
        this.taskExecutor.execute((Runnable)this);
    }

    public void destroy() {
        try {
            this.websocket.close();
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, null, ex);
        }
    }

    public List<Depth> getAllDepthSince(long timestamp) {
        List<Depth> result = new ArrayList<Depth>();
        int length = this.depthHistory.size();
        for (int i = 0; i < length; ++i) {
            Depth depth = this.depthHistory.get(i);
            if (depth == null || depth.getStamp() <= timestamp) continue;
            result = this.depthHistory.subList(i, length - 1);
            break;
        }
        return result;
    }

    @Override
    public void tickerEvent(Ticker ticker) {
        this.tickerHistory.add(ticker);
    }

    @Override
    public void depthEvent(Depth depth) {
        this.depthHistory.add(depth);
    }

    public List<Depth> getDepthHistory() {
        return this.depthHistory;
    }

    public List<Ticker> getTickerHistory() {
        return this.tickerHistory;
    }

    @Override
    public void run() {
        try {
            this.websocket.addListener((WebSocketClientListener)new MtGoxSocketListener(this.logger, this));
            this.websocket.open("ws://websocket.mtgox.com/mtgox");
            this.logger.info("WS API started.");
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, null, ex);
        }
    }
}

