/*
 * Decompiled with CFR 0.152.
 */
package to.sparks;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import to.sparks.mtgox.MtGoxAPI;
import to.sparks.mtgox.model.Depth;
import to.sparks.mtgox.model.FullDepth;
import to.sparks.mtgox.model.Offer;
import to.sparks.mtgox.model.Ticker;

public class MtGoxExample {
    static final Logger logger = Logger.getLogger(MtGoxExample.class.getName());

    public static void main(String[] args) throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("to/sparks/Beans.xml");
        MtGoxAPI mtgoxUSD = (MtGoxAPI)context.getBean("mtgoxUSD");
        Ticker ticker = mtgoxUSD.getTicker();
        logger.log(Level.INFO, "Last price: {0}", ticker.getLast().getDisplay());
        logger.info("Downloading fulldepth...");
        FullDepth fullDepth = mtgoxUSD.getFullDepth();
        ArrayList<Offer> asks = new ArrayList<Offer>(Arrays.asList(fullDepth.getAsks()));
        ArrayList<Offer> bids = new ArrayList<Offer>(Arrays.asList(fullDepth.getBids()));
        long mostRecentAskTimestamp = MtGoxExample.getMostRecentTimestamp(asks);
        long mostRecentBidTimestamp = MtGoxExample.getMostRecentTimestamp(bids);
        long mostRecentTimestamp = mostRecentAskTimestamp < mostRecentBidTimestamp ? mostRecentBidTimestamp : mostRecentAskTimestamp;
        List<Depth> updates = mtgoxUSD.getAllDepthSince(mostRecentTimestamp);
        for (Depth update : updates) {
            if (update.getStamp() < mostRecentTimestamp) {
                logger.log(Level.WARNING, "Warning:  Out of order timestamp found. {0} < {1}", new Object[]{update.getStamp(), mostRecentTimestamp});
                continue;
            }
            ArrayList<Offer> offers = update.getType_str().equalsIgnoreCase("ASK") ? asks : bids;
            mostRecentTimestamp = update.getStamp();
            MtGoxExample.updateDepth(update, offers);
        }
        logger.log(Level.INFO, "Asks: {0}  Bids: {1}", new Object[]{asks != null ? Integer.valueOf(asks.size()) : "null", bids != null ? Integer.valueOf(bids.size()) : "null"});
    }

    private static long getMostRecentTimestamp(List<Offer> offers) {
        long mostRecentTimestamp = 0L;
        for (Offer offer : offers) {
            if (offer.getStamp() <= mostRecentTimestamp) continue;
            mostRecentTimestamp = offer.getStamp();
        }
        return mostRecentTimestamp;
    }

    private static void updateDepth(Depth update, List<Offer> depth) {
        ArrayList<Offer> emptyOffers = new ArrayList<Offer>();
        for (Offer offer : depth) {
            if (offer.getAmount().getCredits().equals(BigDecimal.ZERO)) {
                emptyOffers.add(offer);
            }
            if (!offer.getPrice().equals(update.getPrice())) continue;
            offer.setAmount(update.getTotalVolume());
            offer.setStamp(update.getStamp());
            break;
        }
        if (update.getAmount().getCredits().compareTo(BigDecimal.ZERO) > 0) {
            depth.add(update);
        }
        for (Offer offer : emptyOffers) {
            depth.remove(offer);
        }
    }
}

