/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.model;

import java.util.Currency;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;
import to.sparks.mtgox.model.DtoBase;
import to.sparks.mtgox.model.MtGoxBitcoinUnit;
import to.sparks.mtgox.model.MtGoxFiatUnit;

@JsonAutoDetect
public class Offer
extends DtoBase {
    private Currency currency;
    private long price_int;
    private MtGoxBitcoinUnit amount;
    private long stamp;

    public Offer(long price_int, MtGoxBitcoinUnit amount, long stamp, Currency currency) {
        this.price_int = price_int;
        this.amount = amount;
        this.stamp = stamp;
        this.currency = currency;
    }

    public Offer(@JsonProperty(value="price") double price, @JsonProperty(value="amount") double amount, @JsonProperty(value="price_int") long price_int, @JsonProperty(value="amount_int") long amount_int, @JsonProperty(value="stamp") long stamp) {
        this(price_int, MtGoxBitcoinUnit.createBitcoinInstance(amount_int), stamp, null);
    }

    public Currency getCurrency() {
        return this.currency;
    }

    void setCurrency(Currency currency) {
        this.currency = currency;
    }

    long getPrice_int() {
        return this.price_int;
    }

    public MtGoxFiatUnit getPrice() {
        MtGoxFiatUnit price = null;
        if (this.currency == null) {
            throw new RuntimeException("Error: getPrice called before currency was initialised.");
        }
        price = MtGoxFiatUnit.createCurrencyInstance(this.price_int, this.currency);
        return price;
    }

    public MtGoxBitcoinUnit getAmount() {
        return this.amount;
    }

    public long getStamp() {
        return this.stamp;
    }

    public void setAmount(MtGoxBitcoinUnit amount) {
        this.amount = amount;
    }

    public void setStamp(long stamp) {
        this.stamp = stamp;
    }
}

