/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.model;

import java.util.Currency;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;
import to.sparks.mtgox.model.DtoBase;
import to.sparks.mtgox.model.MtGoxBitcoinUnit;
import to.sparks.mtgox.model.MtGoxFiatUnit;
import to.sparks.mtgox.model.MtGoxUnitOfCredit;

@JsonAutoDetect
public class TickerPrice
extends DtoBase {
    private MtGoxUnitOfCredit priceValue;
    private String display;
    private String display_short;
    private Currency currency = null;

    public TickerPrice(@JsonProperty(value="value") double value, @JsonProperty(value="value_int") long value_int, @JsonProperty(value="display") String display, @JsonProperty(value="display_short") String display_short, @JsonProperty(value="currency") String currency) {
        this.display = display;
        this.display_short = display_short;
        if (currency.equalsIgnoreCase("BTC")) {
            this.priceValue = MtGoxBitcoinUnit.createBitcoinInstance(value_int);
        } else {
            this.currency = Currency.getInstance(currency);
            this.priceValue = MtGoxFiatUnit.createCurrencyInstance(value_int, this.currency);
        }
    }

    public MtGoxUnitOfCredit getPriceValue() {
        return this.priceValue;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getDisplay_short() {
        return this.display_short;
    }
}

