/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.service;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import to.sparks.mtgox.MtGoxAPI;
import to.sparks.mtgox.model.Depth;
import to.sparks.mtgox.model.FullDepth;
import to.sparks.mtgox.model.MtGoxBitcoinUnit;
import to.sparks.mtgox.model.MtGoxFiatUnit;
import to.sparks.mtgox.model.Order;
import to.sparks.mtgox.model.OrderResult;
import to.sparks.mtgox.model.Ticker;
import to.sparks.mtgox.model.Trade;
import to.sparks.mtgox.service.MtGoxHTTPClient;
import to.sparks.mtgox.service.MtGoxWebSocketClient;

class MtGoxServiceImpl
implements MtGoxAPI {
    private static Logger logger;
    private MtGoxWebSocketClient wsApi;
    private Currency currency;
    MtGoxHTTPClient httpAPI;

    public MtGoxServiceImpl(Logger logger, MtGoxHTTPClient httpAPI, MtGoxWebSocketClient mtGoxWebSocketApi, Currency currency) {
        MtGoxServiceImpl.logger = logger;
        this.currency = currency;
        this.httpAPI = httpAPI;
        this.wsApi = mtGoxWebSocketApi;
    }

    @Override
    public List<Depth> getAllDepthSince(long timestamp) {
        return this.wsApi != null ? this.wsApi.getAllDepthSince(timestamp) : null;
    }

    @Override
    public List<Trade> getAllTradesSince(long timestamp) {
        return this.wsApi != null ? this.wsApi.getAllTradesSince(timestamp) : null;
    }

    @Override
    public List<Depth> getDepthHistory() {
        return this.wsApi != null ? this.wsApi.getDepthHistory() : null;
    }

    @Override
    public List<Ticker> getTickerHistory() {
        return this.wsApi != null ? this.wsApi.getTickerHistory() : null;
    }

    @Override
    public List<Trade> getTradeHistory() {
        return this.wsApi != null ? this.wsApi.getTradeHistory() : null;
    }

    @Override
    public FullDepth getFullDepth() throws IOException, Exception {
        return this.httpAPI.getFullDepth(this.currency);
    }

    @Override
    public String placeOrder(MtGoxAPI.OrderType orderType, MtGoxFiatUnit price, MtGoxBitcoinUnit volume) throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (orderType == MtGoxAPI.OrderType.Bid) {
            params.put("type", "bid");
        } else {
            params.put("type", "ask");
        }
        if (price != null) {
            params.put("price_int", String.valueOf(price.getCredits().longValueExact()));
        }
        params.put("amount_int", String.valueOf(volume.getCredits().longValueExact()));
        return this.httpAPI.placeOrder(this.currency, params);
    }

    @Override
    public String placeMarketOrder(MtGoxAPI.OrderType orderType, MtGoxBitcoinUnit volume) throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        return this.placeOrder(orderType, null, volume);
    }

    @Override
    public OrderResult getOrderResult(MtGoxAPI.OrderType orderType, String orderRef) throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (orderType == MtGoxAPI.OrderType.Bid) {
            params.put("type", "bid");
        } else {
            params.put("type", "ask");
        }
        params.put("order", orderRef);
        return this.httpAPI.getPrivateOrderResult(params);
    }

    @Override
    public Order[] getOpenOrders() throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        return this.httpAPI.getOpenOrders();
    }

    @Override
    public Ticker getTicker() throws IOException, Exception {
        return this.httpAPI.getTicker(this.currency);
    }

    @Override
    public Currency getBaseCurrency() {
        return this.currency;
    }
}

