/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.model;

import java.util.Currency;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;
import to.sparks.mtgox.model.DtoBase;
import to.sparks.mtgox.model.IEventTime;
import to.sparks.mtgox.model.MtGoxBitcoinUnit;
import to.sparks.mtgox.model.MtGoxFiatUnit;

@JsonAutoDetect
public class Trade
extends DtoBase
implements IEventTime {
    private MtGoxBitcoinUnit amount;
    private MtGoxFiatUnit price;
    private long date;
    private String item;
    private String type;
    private String primary;
    private String properties;
    private Currency price_currency;
    private String tid;
    private String trade_type;

    public Trade(@JsonProperty(value="tid") String tid, @JsonProperty(value="primary") String primary, @JsonProperty(value="price_currency") String price_currency, @JsonProperty(value="type") String type, @JsonProperty(value="properties") String properties, @JsonProperty(value="item") String item, @JsonProperty(value="amount") double amount, @JsonProperty(value="price") double price, @JsonProperty(value="trade_type") String trade_type, @JsonProperty(value="date") long date, @JsonProperty(value="amount_int") long amount_int, @JsonProperty(value="price_int") long price_int) {
        this.tid = tid;
        this.primary = primary;
        this.price_currency = Currency.getInstance(price_currency);
        this.type = type;
        this.properties = properties;
        this.item = item;
        this.trade_type = trade_type;
        this.date = date;
        this.amount = MtGoxBitcoinUnit.createBitcoinInstance(amount_int);
        this.price = MtGoxFiatUnit.createCurrencyInstance(price_int, this.price_currency);
    }

    public String getTradeId() {
        return this.tid;
    }

    public String getPrimary() {
        return this.primary;
    }

    public Currency getPriceCurrency() {
        return this.price_currency;
    }

    public String getType() {
        return this.type;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getItem() {
        return this.item;
    }

    public String getTrade_type() {
        return this.trade_type;
    }

    public long getDate() {
        return this.date;
    }

    public MtGoxBitcoinUnit getAmount() {
        return this.amount;
    }

    public MtGoxFiatUnit getPrice() {
        return this.price;
    }

    @Override
    public long getEventTime() {
        return this.getDate();
    }
}

