/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.net;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.jwebsocket.api.WebSocketClientEvent;
import org.jwebsocket.api.WebSocketClientListener;
import org.jwebsocket.api.WebSocketPacket;
import to.sparks.mtgox.model.Depth;
import to.sparks.mtgox.model.DynaBean;
import to.sparks.mtgox.model.OpPrivateDepth;
import to.sparks.mtgox.model.OpPrivateTicker;
import to.sparks.mtgox.model.OpPrivateTrade;
import to.sparks.mtgox.model.Ticker;
import to.sparks.mtgox.model.Trade;
import to.sparks.mtgox.net.MtGoxEventListener;

public class MtGoxSocketListener
implements WebSocketClientListener {
    private MtGoxEventListener eventListener;
    private Logger logger;

    public MtGoxSocketListener(Logger logger, MtGoxEventListener eventListener) {
        this.eventListener = eventListener;
        this.logger = logger;
    }

    public void processOpened(WebSocketClientEvent aEvent) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processPacket(WebSocketClientEvent aEvent, WebSocketPacket aPacket) {
        if (aEvent == null) throw new UnsupportedOperationException("Not supported yet.");
        if (aPacket == null || aPacket.getFrameType() != 0) throw new UnsupportedOperationException("Not supported yet.");
        try {
            JsonFactory factory = new JsonFactory();
            ObjectMapper mapper = new ObjectMapper();
            JsonParser jp = factory.createJsonParser(aPacket.getUTF8());
            DynaBean op = (DynaBean)mapper.readValue(jp, DynaBean.class);
            if (op.get("op") != null && op.get("op").equals("private")) {
                String messageType = op.get("private").toString();
                if (messageType.equalsIgnoreCase("ticker")) {
                    OpPrivateTicker opPrivateTicker = (OpPrivateTicker)mapper.readValue(factory.createJsonParser(aPacket.getUTF8()), OpPrivateTicker.class);
                    Ticker ticker = opPrivateTicker.getTicker();
                    this.eventListener.tickerEvent(ticker);
                    this.logger.log(Level.FINE, "Ticker: last: {0}", new Object[]{ticker.getLast().getDisplay()});
                    return;
                } else if (messageType.equalsIgnoreCase("depth")) {
                    OpPrivateDepth opPrivateDepth = (OpPrivateDepth)mapper.readValue(factory.createJsonParser(aPacket.getUTF8()), OpPrivateDepth.class);
                    Depth depth = opPrivateDepth.getDepth();
                    this.eventListener.depthEvent(depth);
                    this.logger.log(Level.FINE, "Depth total volume: {0}", new Object[]{depth.getTotalVolume().getCredits()});
                    return;
                } else if (messageType.equalsIgnoreCase("trade")) {
                    OpPrivateTrade opPrivateTrade = (OpPrivateTrade)mapper.readValue(factory.createJsonParser(aPacket.getUTF8()), OpPrivateTrade.class);
                    Trade trade = opPrivateTrade.getTrade();
                    this.eventListener.tradeEvent(trade);
                    this.logger.log(Level.FINE, "Trade price: {0}", new Object[]{trade.getPrice().getCredits()});
                    return;
                } else {
                    this.logger.log(Level.WARNING, "Unknown private operation: {0}", new Object[]{aPacket.getUTF8()});
                }
                return;
            }
            this.logger.log(Level.WARNING, "Unknown operation: {0}, payload: {1}", new Object[]{op.get("op")});
            return;
        }
        catch (IOException ex) {
            this.logger.log(Level.SEVERE, null, ex);
        }
    }

    public void processClosed(WebSocketClientEvent aEvent) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

