/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.net;

import java.util.Currency;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class MtGoxUrlFactory {
    private static String MTGOX_HTTP_API_URL = "https://mtgox.com/api/";
    private static String MTGOX_HTTP_API_VERSION = "1/";
    private static final HashMap<Currency, String> currencyMap;
    private static final HashMap<RestCommand, String> restMap;
    private static final String[] currencyList;

    public static String getUrlForRestCommand(RestCommand restCommand) throws Exception {
        return MtGoxUrlFactory.getUrlForRestCommand("", restCommand);
    }

    public static String getUrlForRestCommand(Currency currency, RestCommand restCommand) throws Exception {
        return MtGoxUrlFactory.getUrlForRestCommand(currency.getCurrencyCode(), restCommand);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getUrlForRestCommand(String currencyCode, RestCommand restCommand) throws Exception {
        StringBuilder url = new StringBuilder();
        if (!StringUtils.isEmpty((String)currencyCode) && !currencyCode.equalsIgnoreCase("BTC") && !currencyMap.containsKey(Currency.getInstance(currencyCode))) throw new Exception("Unknown currency: " + currencyCode);
        if (!restMap.containsKey((Object)restCommand)) throw new Exception("Unknown command: " + restCommand.toString());
        url.append(MTGOX_HTTP_API_URL);
        url.append(MTGOX_HTTP_API_VERSION);
        Currency currency = null;
        try {
            currency = Currency.getInstance(currencyCode);
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        if (StringUtils.isEmpty((String)currencyCode) || currencyCode.equalsIgnoreCase("BTC") || !currencyMap.containsKey(currency)) {
            url.append("generic/");
        } else {
            url.append(currencyMap.get(Currency.getInstance(currencyCode)));
        }
        url.append(restMap.get((Object)restCommand));
        return url.toString();
    }

    static {
        currencyList = new String[]{"USD", "AUD", "CAD", "CHF", "CNY", "DKK", "EUR", "GBP", "HKD", "JPY", "NZD", "PLN", "RUB", "SEK", "SGD", "THB"};
        currencyMap = new HashMap();
        for (String currency : currencyList) {
            currencyMap.put(Currency.getInstance(currency), "BTC" + currency + "/");
        }
        restMap = new HashMap();
        restMap.put(RestCommand.PrivateOrderAdd, "private/order/add");
        restMap.put(RestCommand.PrivateOrderResult, "private/order/result");
        restMap.put(RestCommand.PrivateOrders, "private/orders");
        restMap.put(RestCommand.PrivateInfo, "private/info");
        restMap.put(RestCommand.FullDepth, "fulldepth");
        restMap.put(RestCommand.Ticker, "ticker");
        restMap.put(RestCommand.CurrencyInfo, "currency");
    }

    public static enum RestCommand {
        PrivateOrderAdd,
        PrivateOrderResult,
        PrivateOrders,
        PrivateInfo,
        FullDepth,
        Ticker,
        CurrencyInfo;

    }
}

