/*
 * Decompiled with CFR 0.152.
 */
package to.sparks;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import to.sparks.mtgox.MtGoxAPI;
import to.sparks.mtgox.model.AccountInfo;
import to.sparks.mtgox.model.CurrencyInfo;
import to.sparks.mtgox.model.MtGoxUnitOfCredit;
import to.sparks.mtgox.model.Order;
import to.sparks.mtgox.model.Ticker;

public class MtGoxExample {
    static final Logger logger = Logger.getLogger(MtGoxExample.class.getName());

    public static void main(String[] args) throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("to/sparks/Beans.xml");
        MtGoxAPI mtgoxUSD = (MtGoxAPI)context.getBean("mtgoxUSD");
        CurrencyInfo currencyInfo = mtgoxUSD.getCurrencyInfo(mtgoxUSD.getBaseCurrency());
        logger.log(Level.INFO, "Base currency: {0}", currencyInfo.getCurrency().getCurrencyCode());
        Ticker ticker = mtgoxUSD.getTicker();
        logger.log(Level.INFO, "Last price: {0}", ticker.getLast().getDisplay());
        try {
            AccountInfo info = mtgoxUSD.getAccountInfo();
            logger.log(Level.INFO, "Logged into account: {0}", info.getLogin());
            long price_int = 100000L;
            long amount_int = 100000000L;
            MtGoxUnitOfCredit fiatUnit = new MtGoxUnitOfCredit(price_int, currencyInfo);
            MtGoxUnitOfCredit bitcoinUnit = new MtGoxUnitOfCredit(amount_int);
            String orderRef = mtgoxUSD.placeOrder(MtGoxAPI.OrderType.Bid, fiatUnit, bitcoinUnit);
            logger.log(Level.INFO, "orderRef: {0}", new Object[]{orderRef});
            for (Order order : mtgoxUSD.getOpenOrders()) {
                logger.log(Level.INFO, "Open order: {0} status: {1} price: {2}{3} amount: {4}", new Object[]{order.getOid(), order.getStatus(), order.getCurrency().getCurrencyCode(), order.getPrice().getDisplay(), order.getAmount().getDisplay()});
            }
            mtgoxUSD.cancelOrder(MtGoxAPI.OrderType.Bid, orderRef);
            for (Order order : mtgoxUSD.getOpenOrders()) {
                logger.log(Level.INFO, "Open order: {0} status: {1} price: {2}{3} amount: {4}", new Object[]{order.getOid(), order.getStatus(), order.getCurrency().getCurrencyCode(), order.getPrice().getDisplay(), order.getAmount().getDisplay()});
            }
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.SEVERE, "Private functions require your private mtgox api keys. Run java with these command line arguments:  -Dapi.key=YOUR_KEY -Dapi.secret=YOUR_SECRET ", ex);
        }
    }
}

