/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.model;

import java.util.Currency;
import org.codehaus.jackson.annotate.JsonProperty;
import to.sparks.mtgox.model.DtoBase;

public class CurrencyInfo
extends DtoBase {
    private String currency_code;
    private String name;
    private String symbol;
    private int decimals;
    private int display_decimals;
    private String symbol_position;
    private boolean virtual;
    private String ticker_channel;
    private String depth_channel;

    public CurrencyInfo(@JsonProperty(value="currency") String currency_code, @JsonProperty(value="name") String name, @JsonProperty(value="symbol") String symbol, @JsonProperty(value="decimals") int decimals, @JsonProperty(value="display_decimals") int display_decimals, @JsonProperty(value="symbol_position") String symbol_position, @JsonProperty(value="virtual") String virtual, @JsonProperty(value="ticker_channel") String ticker_channel, @JsonProperty(value="depth_channel") String depth_channel) {
        this.currency_code = currency_code;
        this.name = name;
        this.symbol = symbol;
        this.decimals = decimals;
        this.display_decimals = display_decimals;
        this.symbol_position = symbol_position;
        this.virtual = virtual.trim().equalsIgnoreCase("Y");
        this.ticker_channel = ticker_channel;
        this.depth_channel = depth_channel;
    }

    public Currency getCurrency() {
        if (this.isVirtual()) {
            throw new UnsupportedOperationException("Virtual MtGox currencies cannot be expressed as a Java currency.");
        }
        return Currency.getInstance(this.currency_code);
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public int getDisplay_decimals() {
        return this.display_decimals;
    }

    public String getSymbol_position() {
        return this.symbol_position;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public String getTicker_channel() {
        return this.ticker_channel;
    }

    public String getDepth_channel() {
        return this.depth_channel;
    }
}

