/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;
import to.sparks.mtgox.model.DtoBase;
import to.sparks.mtgox.model.Result;

public class JSONSource<T extends DtoBase> {
    private JsonFactory factory = new JsonFactory();
    private ObjectMapper mapper = new ObjectMapper();

    public JSONSource() {
        this.factory.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, false);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.mapper.setDateFormat((DateFormat)df);
    }

    public T getResultFromStream(InputStream in, Class clazz) throws IOException {
        JsonParser jp = this.factory.createJsonParser(in);
        return this.getResult(jp, clazz);
    }

    public T getResultFromFile(String filename, Class clazz) throws IOException {
        return this.getResultFromStream(new FileInputStream(filename), clazz);
    }

    public T getResultFromString(String json, Class clazz) throws IOException {
        JsonParser jp = this.factory.createJsonParser(json);
        return this.getResult(jp, clazz);
    }

    public T getResult(JsonParser jp, Class clazz) throws IOException {
        JavaType topMost = this.mapper.getTypeFactory().constructParametricType(Result.class, new Class[]{clazz});
        return (T)((DtoBase)this.mapper.readValue(jp, topMost));
    }

    public String getDTOasJSON(DtoBase dto) throws IOException {
        return this.mapper.writeValueAsString((Object)dto);
    }
}

