/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.model;

import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonProperty;
import to.sparks.mtgox.model.CurrencyInfo;
import to.sparks.mtgox.model.CurrencyKludge;
import to.sparks.mtgox.model.DtoBase;
import to.sparks.mtgox.model.MtGoxBitcoin;
import to.sparks.mtgox.model.MtGoxFiatCurrency;
import to.sparks.mtgox.model.MtGoxUnitOfCredit;

@JsonAutoDetect
public class Offer
extends DtoBase
implements CurrencyKludge {
    protected CurrencyInfo currencyInfo;
    private long price_int;
    private long stamp;
    private long amount_int;

    public Offer(@JsonProperty(value="price") double price, @JsonProperty(value="amount") double amount, @JsonProperty(value="price_int") long price_int, @JsonProperty(value="amount_int") long amount_int, @JsonProperty(value="stamp") long stamp) {
        this.price_int = price_int;
        this.amount_int = amount_int;
        this.stamp = stamp;
    }

    public CurrencyInfo getCurrencyInfo() {
        return this.currencyInfo;
    }

    @Override
    public void setCurrencyInfo(CurrencyInfo currencyInfo) {
        this.currencyInfo = currencyInfo;
    }

    public MtGoxFiatCurrency getPrice() {
        MtGoxFiatCurrency price = null;
        if (this.currencyInfo == null) {
            throw new RuntimeException("Error: getPrice called before currency was initialised.");
        }
        price = new MtGoxFiatCurrency(this.price_int, this.currencyInfo);
        return price;
    }

    public MtGoxBitcoin getAmount() {
        MtGoxBitcoin amount = new MtGoxBitcoin(this.amount_int);
        return amount;
    }

    public long getStamp() {
        return this.stamp;
    }

    public void setAmount(MtGoxUnitOfCredit amount) {
        this.amount_int = amount.getCredits().longValueExact();
    }

    public void setStamp(long stamp) {
        this.stamp = stamp;
    }
}

