/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.service;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import to.sparks.mtgox.HTTPClientV0;
import to.sparks.mtgox.HTTPClientV1;
import to.sparks.mtgox.MtGoxAPI;
import to.sparks.mtgox.WebSocketClient;
import to.sparks.mtgox.model.AccountInfo;
import to.sparks.mtgox.model.CurrencyInfo;
import to.sparks.mtgox.model.CurrencyKludge;
import to.sparks.mtgox.model.Depth;
import to.sparks.mtgox.model.DtoBase;
import to.sparks.mtgox.model.FullDepth;
import to.sparks.mtgox.model.MtGoxBitcoin;
import to.sparks.mtgox.model.MtGoxFiatCurrency;
import to.sparks.mtgox.model.Order;
import to.sparks.mtgox.model.OrderCancelResult;
import to.sparks.mtgox.model.OrderResult;
import to.sparks.mtgox.model.Ticker;
import to.sparks.mtgox.model.Trade;

class APIService
implements MtGoxAPI {
    private static Logger logger;
    private WebSocketClient wsApi;
    HTTPClientV0 httpAPIV0;
    HTTPClientV1 httpAPIV1;
    CurrencyInfo currencyInfo;

    public APIService(Logger logger, HTTPClientV0 httpAPIV0, HTTPClientV1 httpAPIV1, WebSocketClient mtGoxWebSocketApi, Currency currency) throws IOException, Exception {
        APIService.logger = logger;
        this.httpAPIV0 = httpAPIV0;
        this.httpAPIV1 = httpAPIV1;
        this.wsApi = mtGoxWebSocketApi;
        this.currencyInfo = httpAPIV1.getCurrencyInfo(currency);
    }

    @Override
    public void shutdown() {
        if (this.wsApi != null) {
            this.wsApi.shutdown();
        }
    }

    @Override
    public List<Depth> getAllDepthSince(long timestamp) {
        List<Depth> depths = this.wsApi.getAllDepthSince(timestamp);
        for (Depth depth : depths) {
            this.currencyKludge(depth);
        }
        return depths;
    }

    @Override
    public List<Trade> getAllTradesSince(long timestamp) {
        List<Trade> trades = this.wsApi.getAllTradesSince(timestamp);
        for (Trade trade : trades) {
            this.currencyKludge(trade);
        }
        return trades;
    }

    @Override
    public List<Depth> getDepthHistory() {
        List<Depth> depthHistory = this.wsApi.getDepthHistory();
        for (Depth depth : depthHistory) {
            this.currencyKludge(depth);
        }
        return depthHistory;
    }

    @Override
    public List<Ticker> getTickerHistory() {
        List<Ticker> tickerHistory = this.wsApi.getTickerHistory();
        for (Ticker ticker : tickerHistory) {
            this.currencyKludge(ticker);
        }
        return tickerHistory;
    }

    @Override
    public List<Trade> getTradeHistory() {
        List<Trade> tradeHistory = this.wsApi.getTradeHistory();
        for (Trade trade : tradeHistory) {
            this.currencyKludge(trade);
        }
        return tradeHistory;
    }

    @Override
    public FullDepth getFullDepth() throws IOException, Exception {
        FullDepth fullDepth = this.httpAPIV1.getFullDepth(this.currencyInfo.getCurrency());
        this.currencyKludge(fullDepth);
        return fullDepth;
    }

    @Override
    public String placeOrder(MtGoxAPI.OrderType orderType, MtGoxFiatCurrency price, MtGoxBitcoin volume) throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (orderType == MtGoxAPI.OrderType.Bid) {
            params.put("type", "bid");
        } else {
            params.put("type", "ask");
        }
        if (price != null) {
            params.put("price_int", String.valueOf(price.getCredits().unscaledValue().longValue()));
        }
        params.put("amount_int", String.valueOf(volume.getCredits().unscaledValue().longValue()));
        return this.httpAPIV1.placeOrder(this.currencyInfo.getCurrency(), params);
    }

    @Override
    public String placeMarketOrder(MtGoxAPI.OrderType orderType, MtGoxBitcoin volume) throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        return this.placeOrder(orderType, null, volume);
    }

    @Override
    public OrderResult getOrderResult(MtGoxAPI.OrderType orderType, String orderRef) throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (orderType == MtGoxAPI.OrderType.Bid) {
            params.put("type", "bid");
        } else {
            params.put("type", "ask");
        }
        params.put("order", orderRef);
        OrderResult orderResult = this.httpAPIV1.getPrivateOrderResult(params);
        this.currencyKludge(orderResult);
        return orderResult;
    }

    @Override
    public Order[] getOpenOrders() throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        Order[] orders;
        for (Order order : orders = this.httpAPIV1.getOpenOrders()) {
            this.currencyKludge(order);
        }
        return orders;
    }

    @Override
    public Ticker getTicker() throws IOException, Exception {
        Ticker ticker = this.httpAPIV1.getTicker(this.currencyInfo.getCurrency());
        this.currencyKludge(ticker);
        return ticker;
    }

    @Override
    public Currency getBaseCurrency() {
        return this.currencyInfo.getCurrency();
    }

    @Override
    public AccountInfo getAccountInfo() throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        AccountInfo info = this.httpAPIV1.getPrivateInfo();
        this.currencyKludge(info);
        return info;
    }

    @Override
    public CurrencyInfo getCurrencyInfo(Currency currency) throws IOException, Exception {
        return this.httpAPIV1.getCurrencyInfo(currency);
    }

    @Override
    public CurrencyInfo getCurrencyInfo(String currencyCode) throws Exception {
        return this.httpAPIV1.getCurrencyInfo(currencyCode);
    }

    private void currencyKludge(DtoBase o) {
        if (o != null && o instanceof CurrencyKludge) {
            ((CurrencyKludge)((Object)o)).setCurrencyInfo(this.currencyInfo);
        }
    }

    @Override
    public OrderCancelResult cancelOrder(MtGoxAPI.OrderType orderType, String orderRef) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (orderType == MtGoxAPI.OrderType.Bid) {
            params.put("type", "2");
        } else {
            params.put("type", "1");
        }
        params.put("oid", orderRef);
        return this.httpAPIV0.cancelOrder(params);
    }

    @Override
    public OrderCancelResult cancelOrder(Order order) throws Exception {
        return this.cancelOrder(order.getType(), order.getOid());
    }
}

