/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jwebsocket.api.WebSocketClientListener;
import org.jwebsocket.client.java.BaseWebSocket;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import to.sparks.mtgox.WebSocketClient;
import to.sparks.mtgox.model.Depth;
import to.sparks.mtgox.model.IEventTime;
import to.sparks.mtgox.model.Ticker;
import to.sparks.mtgox.model.Trade;
import to.sparks.mtgox.net.EventListener;
import to.sparks.mtgox.net.SocketListener;

class WebSocketClientService
implements EventListener,
Runnable,
WebSocketClient {
    private Logger logger;
    private List<Depth> depthHistory = new CopyOnWriteArrayList<Depth>();
    private List<Ticker> tickerHistory = new CopyOnWriteArrayList<Ticker>();
    private List<Trade> tradeHistory = new CopyOnWriteArrayList<Trade>();
    final BaseWebSocket websocket = new BaseWebSocket();
    private ThreadPoolTaskExecutor taskExecutor;

    public WebSocketClientService(Logger logger, ThreadPoolTaskExecutor taskExecutor) {
        this.logger = logger;
        this.taskExecutor = taskExecutor;
    }

    public void init() {
        this.taskExecutor.execute((Runnable)this);
    }

    public void destroy() {
        try {
            this.websocket.close();
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void shutdown() {
        this.taskExecutor.shutdown();
    }

    @Override
    public List<Depth> getAllDepthSince(long timestamp) {
        int eventIndex = this.getEventIndex(this.depthHistory, timestamp);
        return eventIndex <= this.depthHistory.size() - 1 ? this.depthHistory.subList(eventIndex, this.depthHistory.size()) : new ArrayList<Depth>();
    }

    @Override
    public List<Trade> getAllTradesSince(long timestamp) {
        int eventIndex = this.getEventIndex(this.tradeHistory, timestamp);
        return eventIndex <= this.tradeHistory.size() - 1 ? this.tradeHistory.subList(eventIndex, this.tradeHistory.size()) : new ArrayList<Trade>();
    }

    private int getEventIndex(List list, long timestamp) {
        int length;
        int result = length = list.size();
        for (int i = 0; i < length; ++i) {
            IEventTime eventTime = (IEventTime)list.get(i);
            if (eventTime == null || eventTime.getEventTime() <= timestamp) continue;
            result = i;
            break;
        }
        return result;
    }

    @Override
    public void tradeEvent(Trade trade) {
        this.getTradeHistory().add(trade);
    }

    @Override
    public void tickerEvent(Ticker ticker) {
        this.tickerHistory.add(ticker);
    }

    @Override
    public void depthEvent(Depth depth) {
        this.depthHistory.add(depth);
    }

    @Override
    public List<Depth> getDepthHistory() {
        return this.depthHistory;
    }

    @Override
    public List<Ticker> getTickerHistory() {
        return this.tickerHistory;
    }

    @Override
    public List<Trade> getTradeHistory() {
        return this.tradeHistory;
    }

    @Override
    public void run() {
        try {
            this.websocket.addListener((WebSocketClientListener)new SocketListener(this.logger, this));
            this.websocket.open("ws://websocket.mtgox.com/mtgox");
            this.logger.info("WS API started.");
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, null, ex);
        }
    }
}

