/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.examples;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import to.sparks.mtgox.MtGoxAPI;
import to.sparks.mtgox.model.AccountInfo;
import to.sparks.mtgox.model.Order;
import to.sparks.mtgox.model.Ticker;

public class HowToGetInfo {
    static final Logger logger = Logger.getLogger(HowToGetInfo.class.getName());

    public static void main(String[] args) throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("to/sparks/Beans.xml");
        MtGoxAPI mtgoxUSD = (MtGoxAPI)context.getBean("mtgoxUSD");
        Ticker ticker = mtgoxUSD.getTicker();
        logger.log(Level.INFO, "Last price: {0}", ticker.getLast().getDisplay());
        AccountInfo info = mtgoxUSD.getAccountInfo();
        logger.log(Level.INFO, "Logged into account: {0}", info.getLogin());
        Object[] openOrders = mtgoxUSD.getOpenOrders();
        if (ArrayUtils.isNotEmpty((Object[])openOrders)) {
            for (Object order : openOrders) {
                logger.log(Level.INFO, "Open order: {0} status: {1} price: {2}{3} amount: {4}", new Object[]{((Order)order).getOid(), ((Order)order).getStatus(), ((Order)order).getCurrency().getCurrencyCode(), ((Order)order).getPrice().getDisplay(), ((Order)order).getAmount().getDisplay()});
            }
        } else {
            logger.info("There are no currently open bid or ask orders.");
        }
        mtgoxUSD.shutdown();
    }
}

