/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.examples;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import to.sparks.mtgox.MtGoxAPI;
import to.sparks.mtgox.model.CurrencyInfo;
import to.sparks.mtgox.model.MtGoxBitcoin;
import to.sparks.mtgox.model.MtGoxFiatCurrency;

public class PlaceOrders {
    static final Logger logger = Logger.getLogger(PlaceOrders.class.getName());

    public static void main(String[] args) throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("to/sparks/Beans.xml");
        MtGoxAPI mtgoxUSD = (MtGoxAPI)context.getBean("mtgoxUSD");
        CurrencyInfo currencyInfo = mtgoxUSD.getCurrencyInfo(mtgoxUSD.getBaseCurrency());
        logger.log(Level.INFO, "Base currency: {0}", currencyInfo.getCurrency().getCurrencyCode());
        MtGoxFiatCurrency fiatUnit = new MtGoxFiatCurrency(0.01, currencyInfo);
        MtGoxBitcoin bitcoinUnit = new MtGoxBitcoin(1.0);
        String orderRef = mtgoxUSD.placeOrder(MtGoxAPI.OrderType.Bid, fiatUnit, bitcoinUnit);
        logger.log(Level.INFO, "orderRef: {0}", new Object[]{orderRef});
        mtgoxUSD.cancelOrder(MtGoxAPI.OrderType.Bid, orderRef);
        mtgoxUSD.shutdown();
    }
}

