/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.example;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import to.sparks.mtgox.MtGoxHTTPClient;
import to.sparks.mtgox.model.MtGoxBitcoin;
import to.sparks.mtgox.model.SendBitcoinsTransaction;
import to.sparks.mtgox.model.Wallet;

public class HowToWithdrawBitcoins {
    static final Logger logger = Logger.getLogger(HowToWithdrawBitcoins.class.getName());

    public static void main(String[] args) throws Exception {
        MtGoxBitcoin fee;
        MtGoxBitcoin transferAmount;
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("to/sparks/mtgox/example/Beans.xml");
        MtGoxHTTPClient mtGoxAPI = (MtGoxHTTPClient)context.getBean("mtgoxUSD");
        HashMap<String, Wallet> wallets = mtGoxAPI.getAccountInfo().getWallets();
        Wallet btcWallet = wallets.get("BTC");
        MtGoxBitcoin mtgoxBalance = (MtGoxBitcoin)btcWallet.getBalance();
        logger.log(Level.INFO, "MtGox account balance: BTC {0}", mtgoxBalance.toPlainString());
        if (mtgoxBalance.compareTo(BigDecimal.ZERO) > 0 && (transferAmount = new MtGoxBitcoin(mtgoxBalance.subtract(fee = new MtGoxBitcoin(5.0E-4)))).compareTo(BigDecimal.ZERO) > 0) {
            logger.log(Level.INFO, "Transferring BTC {0} to bitcoin address {1} and paying fee {2}", new Object[]{transferAmount.toPlainString(), args[0], fee.toPlainString()});
            SendBitcoinsTransaction trx = mtGoxAPI.sendBitcoins(args[0], transferAmount, fee, true, false);
            logger.log(Level.INFO, "Transfer success.  trx: {0}", trx.getTrx());
        }
    }
}

