/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.Currency;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import to.sparks.mtgox.model.DtoBase;
import to.sparks.mtgox.model.Result;
import to.sparks.mtgox.net.JSONSource;

public class CurrencyInfo
extends DtoBase {
    private String currency_code;
    private String name;
    private String symbol;
    private int decimals;
    private int display_decimals;
    private String symbol_position;
    private boolean virtual;
    private String ticker_channel;
    private String depth_channel;
    private static final String BITCOIN_INFO_JSON = "{\"result\":\"success\",\"return\":{\"currency\":\"BTC\",\"name\":\"Bitcoin\",\"symbol\":\"BTC\",\"decimals\":\"8\",\"display_decimals\":\"2\",\"symbol_position\":\"after\",\"virtual\":\"Y\",\"ticker_channel\":\"13edff67-cfa0-4d99-aa76-52bd15d6a058\",\"depth_channel\":\"7d3d7ae3-7da7-48cf-9c82-51d7ab3fe60f\"}}";
    public static CurrencyInfo BitcoinCurrencyInfo;

    public CurrencyInfo(@JsonProperty(value="currency") String currency_code, @JsonProperty(value="name") String name, @JsonProperty(value="symbol") String symbol, @JsonProperty(value="decimals") int decimals, @JsonProperty(value="display_decimals") int display_decimals, @JsonProperty(value="symbol_position") String symbol_position, @JsonProperty(value="virtual") String virtual, @JsonProperty(value="ticker_channel") String ticker_channel, @JsonProperty(value="depth_channel") String depth_channel) {
        this.currency_code = currency_code;
        this.name = name;
        this.symbol = symbol;
        this.decimals = decimals;
        this.display_decimals = display_decimals;
        this.symbol_position = symbol_position;
        this.virtual = virtual.trim().equalsIgnoreCase("Y");
        this.ticker_channel = ticker_channel;
        this.depth_channel = depth_channel;
    }

    public Currency getCurrency() {
        if (this.isVirtual()) {
            throw new UnsupportedOperationException("Virtual MtGox currencies cannot be expressed as a Java currency.");
        }
        return Currency.getInstance(this.currency_code);
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public int getDisplay_decimals() {
        return this.display_decimals;
    }

    public String getSymbol_position() {
        return this.symbol_position;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public String getTicker_channel() {
        return this.ticker_channel;
    }

    public String getDepth_channel() {
        return this.depth_channel;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CurrencyInfo other = (CurrencyInfo)obj;
        return Objects.equals(this.symbol, other.symbol);
    }

    public int hashCode() {
        int hash = 5;
        hash = 79 * hash + Objects.hashCode(this.symbol);
        return hash;
    }

    static {
        try {
            BitcoinCurrencyInfo = (CurrencyInfo)((Result)new JSONSource().getResultFromString(BITCOIN_INFO_JSON, CurrencyInfo.class)).getReturn();
        }
        catch (IOException ex) {
            Logger.getLogger(CurrencyInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

