/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import to.sparks.mtgox.model.CurrencyInfo;

public abstract class MtGoxUnitOfCredit
implements Comparable<BigDecimal> {
    private CurrencyInfo currencyInfo;
    private BigDecimal numUnits;
    private final MathContext mc = new MathContext(0, RoundingMode.HALF_EVEN);

    public MtGoxUnitOfCredit(BigDecimal numUnits, CurrencyInfo currencyInfo) {
        this.numUnits = numUnits.setScale(currencyInfo.getDecimals(), RoundingMode.HALF_EVEN);
        this.currencyInfo = currencyInfo;
    }

    public MtGoxUnitOfCredit(long int_value, CurrencyInfo currencyInfo) {
        this.numUnits = new BigDecimal(BigInteger.valueOf(int_value), currencyInfo.getDecimals(), this.mc);
        this.currencyInfo = currencyInfo;
    }

    public MtGoxUnitOfCredit(double units, CurrencyInfo currencyInfo) {
        this.numUnits = new BigDecimal(units, this.mc).setScale(currencyInfo.getDecimals(), RoundingMode.HALF_EVEN);
        this.currencyInfo = currencyInfo;
    }

    @Override
    public int compareTo(BigDecimal competitor) {
        return this.numUnits.compareTo(competitor);
    }

    @Override
    public int compareTo(MtGoxUnitOfCredit competitor) {
        if (this.isCurrenciesEquivalent(competitor)) {
            return this.compareTo(competitor.getNumUnits());
        }
        throw new UnsupportedOperationException("Currency must be the same.");
    }

    public CurrencyInfo getCurrencyInfo() {
        return this.currencyInfo;
    }

    public void setCurrencyInfo(CurrencyInfo currencyInfo) {
        this.currencyInfo = currencyInfo;
    }

    public BigDecimal getNumUnits() {
        return this.numUnits;
    }

    public long longValueExact() {
        return this.numUnits.longValueExact();
    }

    public long longValue() {
        return this.numUnits.longValue();
    }

    public BigDecimal add(BigDecimal target) {
        return this.numUnits.add(target);
    }

    public BigDecimal subtract(BigDecimal target) {
        return this.numUnits.subtract(target);
    }

    public BigDecimal add(MtGoxUnitOfCredit target) {
        if (this.isCurrenciesEquivalent(target)) {
            return this.add(target.getNumUnits());
        }
        throw new UnsupportedOperationException("Currency must be the same.");
    }

    public BigDecimal subtract(MtGoxUnitOfCredit target) {
        if (this.isCurrenciesEquivalent(target)) {
            return this.subtract(target.getNumUnits());
        }
        throw new UnsupportedOperationException("Currency must be the same.");
    }

    public BigDecimal multiply(BigDecimal target) {
        return this.numUnits.multiply(target);
    }

    public BigDecimal multiply(MtGoxUnitOfCredit target) {
        if (this.isCurrenciesEquivalent(target)) {
            return this.multiply(target.getNumUnits());
        }
        throw new UnsupportedOperationException("Currency must be the same.");
    }

    public BigDecimal divide(BigDecimal target) {
        return this.numUnits.divide(target, RoundingMode.DOWN);
    }

    public BigDecimal divide(MtGoxUnitOfCredit target) {
        if (this.isCurrenciesEquivalent(target)) {
            return this.divide(target.getNumUnits());
        }
        throw new UnsupportedOperationException("Currency must be the same.");
    }

    public BigInteger unscaledValue() {
        return this.numUnits.unscaledValue();
    }

    public String toPlainString() {
        return this.numUnits.toPlainString();
    }

    public boolean equals(MtGoxUnitOfCredit target) {
        if (this.isCurrenciesEquivalent(target)) {
            return this.equals(target.getNumUnits());
        }
        throw new UnsupportedOperationException("Currency must be the same.");
    }

    public boolean equals(BigDecimal target) {
        return this.numUnits.compareTo(target) == 0;
    }

    private boolean isCurrenciesEquivalent(MtGoxUnitOfCredit o) {
        return this.currencyInfo == null && o.getCurrencyInfo() == null || this.currencyInfo != null && this.currencyInfo.equals(o.getCurrencyInfo());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof MtGoxUnitOfCredit) {
            MtGoxUnitOfCredit o = (MtGoxUnitOfCredit)obj;
            if (this.isCurrenciesEquivalent(o)) {
                return this.equals(o.getNumUnits());
            }
        } else if (obj instanceof BigDecimal) {
            return this.equals((BigDecimal)obj);
        }
        return false;
    }

    public int hashCode() {
        int hash = 13;
        hash = 79 * hash + Objects.hashCode(this.currencyInfo);
        hash = 79 * hash + Objects.hashCode(this.numUnits);
        return hash;
    }
}

