/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import to.sparks.mtgox.model.CurrencyInfo;
import to.sparks.mtgox.model.CurrencyKludge;
import to.sparks.mtgox.model.DtoBase;
import to.sparks.mtgox.model.MtGoxBitcoin;
import to.sparks.mtgox.model.MtGoxFiatCurrency;
import to.sparks.mtgox.model.MtGoxUnitOfCredit;
import to.sparks.mtgox.model.TickerPrice;

@JsonAutoDetect
public class Ticker
extends DtoBase
implements CurrencyKludge {
    private TickerPrice high;
    private TickerPrice low;
    private TickerPrice avg;
    private TickerPrice vwap;
    private TickerPrice vol;
    private TickerPrice last_local;
    private TickerPrice last;
    private TickerPrice last_orig;
    private TickerPrice last_all;
    private TickerPrice buy;
    private TickerPrice sell;
    private String currencyCode;

    public Ticker(@JsonProperty(value="high") TickerPrice high, @JsonProperty(value="low") TickerPrice low, @JsonProperty(value="avg") TickerPrice avg, @JsonProperty(value="vwap") TickerPrice vwap, @JsonProperty(value="vol") TickerPrice vol, @JsonProperty(value="last_local") TickerPrice last_local, @JsonProperty(value="last") TickerPrice last, @JsonProperty(value="last_orig") TickerPrice last_orig, @JsonProperty(value="last_all") TickerPrice last_all, @JsonProperty(value="buy") TickerPrice buy, @JsonProperty(value="sell") TickerPrice sell) {
        this.high = high;
        this.low = low;
        this.avg = avg;
        this.vwap = vwap;
        this.vol = vol;
        this.last_local = last_local;
        this.last = last;
        this.last_orig = last_orig;
        this.last_all = last_all;
        this.buy = buy;
        this.sell = sell;
        if (this.vol != null) {
            this.vol.setCurrencyInfo(CurrencyInfo.BitcoinCurrencyInfo);
        }
        this.currencyCode = avg.getCurrencyCode();
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    private static MtGoxUnitOfCredit getMtGoxUnits(long intValue, CurrencyInfo currencyInfo) {
        MtGoxUnitOfCredit result = new MtGoxBitcoin(intValue);
        if (currencyInfo != null && !currencyInfo.isVirtual()) {
            result = new MtGoxFiatCurrency(intValue, currencyInfo);
        }
        return result;
    }

    public MtGoxUnitOfCredit getHigh() {
        return Ticker.getMtGoxUnits(this.high.getPriceValueInt(), this.high.getCurrencyInfo());
    }

    public void setHigh(TickerPrice high) {
        this.high = high;
    }

    public MtGoxUnitOfCredit getLow() {
        return Ticker.getMtGoxUnits(this.low.getPriceValueInt(), this.low.getCurrencyInfo());
    }

    public void setLow(TickerPrice low) {
        this.low = low;
    }

    public MtGoxUnitOfCredit getAvg() {
        return Ticker.getMtGoxUnits(this.avg.getPriceValueInt(), this.avg.getCurrencyInfo());
    }

    public void setAvg(TickerPrice avg) {
        this.avg = avg;
    }

    public MtGoxUnitOfCredit getVwap() {
        return Ticker.getMtGoxUnits(this.vwap.getPriceValueInt(), this.vwap.getCurrencyInfo());
    }

    public void setVwap(TickerPrice vwap) {
        this.vwap = vwap;
    }

    public MtGoxUnitOfCredit getVol() {
        return Ticker.getMtGoxUnits(this.vol.getPriceValueInt(), this.vol.getCurrencyInfo());
    }

    public void setVol(TickerPrice vol) {
        this.vol = vol;
    }

    public MtGoxUnitOfCredit getLast_local() {
        return Ticker.getMtGoxUnits(this.last_local.getPriceValueInt(), this.last_local.getCurrencyInfo());
    }

    public void setLast_local(TickerPrice last_local) {
        this.last_local = last_local;
    }

    public MtGoxUnitOfCredit getLast() {
        return Ticker.getMtGoxUnits(this.last.getPriceValueInt(), this.last.getCurrencyInfo());
    }

    public void setLast(TickerPrice last) {
        this.last = last;
    }

    public TickerPrice getLast_orig() {
        return this.last_orig;
    }

    public void setLast_orig(TickerPrice last_orig) {
        this.last_orig = last_orig;
    }

    public TickerPrice getLast_all() {
        return this.last_all;
    }

    public void setLast_all(TickerPrice last_all) {
        this.last_all = last_all;
    }

    public TickerPrice getBuy() {
        return this.buy;
    }

    public void setBuy(TickerPrice buy) {
        this.buy = buy;
    }

    public TickerPrice getSell() {
        return this.sell;
    }

    public void setSell(TickerPrice sell) {
        this.sell = sell;
    }

    @Override
    public void setCurrencyInfo(CurrencyInfo currencyInfo) {
        this.high.setCurrencyInfo(currencyInfo);
        this.low.setCurrencyInfo(currencyInfo);
        this.avg.setCurrencyInfo(currencyInfo);
        this.vwap.setCurrencyInfo(currencyInfo);
        this.last_local.setCurrencyInfo(currencyInfo);
        this.last.setCurrencyInfo(currencyInfo);
        this.last_orig.setCurrencyInfo(currencyInfo);
        this.last_all.setCurrencyInfo(currencyInfo);
        this.buy.setCurrencyInfo(currencyInfo);
        this.sell.setCurrencyInfo(currencyInfo);
    }
}

