/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.net;

import biz.source_code.base64Coder.Base64Coder;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang.StringUtils;

public class HTTPAuthenticator {
    private String apiKey;
    private String secret;
    protected static Logger logger;

    public HTTPAuthenticator(Logger logger, String apiKey, String secret) {
        this.apiKey = apiKey;
        this.secret = secret;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
        }
    }

    protected InputStream getMtGoxHTTPInputStream(String path, HashMap<String, String> args) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        args.put("nonce", String.valueOf(System.currentTimeMillis()));
        String post_data = HTTPAuthenticator.buildQueryString(args);
        System.setProperty("jsse.enableSNIExtension", "false");
        URL queryUrl = new URL(path);
        HttpURLConnection connection = (HttpURLConnection)queryUrl.openConnection();
        connection.setDoOutput(true);
        connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; mtgox-java client)");
        if (StringUtils.isNotBlank((String)this.secret) && !this.secret.equalsIgnoreCase("${api.secret}")) {
            Mac mac = Mac.getInstance("HmacSHA512");
            SecretKeySpec secret_spec = new SecretKeySpec(Base64Coder.decode((String)this.secret), "HmacSHA512");
            mac.init(secret_spec);
            String signature = new String(Base64Coder.encode((byte[])mac.doFinal(post_data.getBytes()))).replaceAll("\n", "");
            connection.setRequestProperty("Rest-Key", this.apiKey);
            connection.setRequestProperty("Rest-Sign", signature);
        }
        connection.getOutputStream().write(post_data.getBytes());
        return connection.getInputStream();
    }

    protected InputStream getMtGoxHTTPInputStream(String path) throws IOException, NoSuchAlgorithmException, InvalidKeyException {
        return this.getMtGoxHTTPInputStream(path, new HashMap<String, String>());
    }

    private static String buildQueryString(HashMap<String, String> args) throws UnsupportedEncodingException {
        String result = new String();
        for (String hashkey : args.keySet()) {
            if (result.length() > 0) {
                result = result + '&';
            }
            result = result + URLEncoder.encode(hashkey, "UTF-8") + "=" + URLEncoder.encode(args.get(hashkey), "UTF-8");
        }
        return result;
    }
}

