/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.service;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Currency;
import java.util.HashMap;
import java.util.logging.Logger;
import to.sparks.mtgox.MtGoxHTTPClient;
import to.sparks.mtgox.model.AccountInfo;
import to.sparks.mtgox.model.CurrencyInfo;
import to.sparks.mtgox.model.CurrencyKludge;
import to.sparks.mtgox.model.DtoBase;
import to.sparks.mtgox.model.FullDepth;
import to.sparks.mtgox.model.MtGoxBitcoin;
import to.sparks.mtgox.model.MtGoxFiatCurrency;
import to.sparks.mtgox.model.Order;
import to.sparks.mtgox.model.OrderCancelResult;
import to.sparks.mtgox.model.OrderResult;
import to.sparks.mtgox.model.SendBitcoinsTransaction;
import to.sparks.mtgox.model.Ticker;
import to.sparks.mtgox.service.HTTPClientV0Service;
import to.sparks.mtgox.service.HTTPClientV1Service;

class APIService
implements MtGoxHTTPClient {
    private static Logger logger;
    HTTPClientV0Service httpAPIV0;
    HTTPClientV1Service httpAPIV1;
    CurrencyInfo currencyInfo;

    public APIService(Logger logger, HTTPClientV0Service httpAPIV0, HTTPClientV1Service httpAPIV1, Currency currency) throws IOException, Exception {
        APIService.logger = logger;
        this.httpAPIV0 = httpAPIV0;
        this.httpAPIV1 = httpAPIV1;
        this.currencyInfo = httpAPIV1.getCurrencyInfo(currency);
    }

    @Override
    public FullDepth getFullDepth() throws IOException, Exception {
        FullDepth fullDepth = this.httpAPIV1.getFullDepth(this.currencyInfo.getCurrency());
        this.currencyKludge(fullDepth);
        return fullDepth;
    }

    @Override
    public String placeOrder(MtGoxHTTPClient.OrderType orderType, MtGoxFiatCurrency price, MtGoxBitcoin volume) throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (orderType == MtGoxHTTPClient.OrderType.Bid) {
            params.put("type", "bid");
        } else {
            params.put("type", "ask");
        }
        if (price != null) {
            params.put("price_int", String.valueOf(price.unscaledValue().longValue()));
        }
        params.put("amount_int", String.valueOf(volume.unscaledValue().longValue()));
        return this.httpAPIV1.placeOrder(this.currencyInfo.getCurrency(), params);
    }

    @Override
    public String placeMarketOrder(MtGoxHTTPClient.OrderType orderType, MtGoxBitcoin volume) throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        return this.placeOrder(orderType, null, volume);
    }

    @Override
    public OrderResult getOrderResult(MtGoxHTTPClient.OrderType orderType, String orderRef) throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (orderType == MtGoxHTTPClient.OrderType.Bid) {
            params.put("type", "bid");
        } else {
            params.put("type", "ask");
        }
        params.put("order", orderRef);
        OrderResult orderResult = this.httpAPIV1.getPrivateOrderResult(params);
        this.currencyKludge(orderResult);
        return orderResult;
    }

    @Override
    public Order[] getOpenOrders() throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        Order[] orders;
        for (Order order : orders = this.httpAPIV1.getOpenOrders()) {
            this.currencyKludge(order);
        }
        return orders;
    }

    @Override
    public Ticker getTicker() throws IOException, Exception {
        Ticker ticker = this.httpAPIV1.getTicker(this.currencyInfo.getCurrency());
        this.currencyKludge(ticker);
        return ticker;
    }

    @Override
    public Currency getBaseCurrency() {
        return this.currencyInfo.getCurrency();
    }

    @Override
    public AccountInfo getAccountInfo() throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        AccountInfo info = this.httpAPIV1.getPrivateInfo();
        this.currencyKludge(info);
        for (String key : info.getWallets().keySet()) {
            CurrencyInfo walletCurrencyInfo = this.getCurrencyInfo(key);
            ((CurrencyKludge)info.getWallets().get(key)).setCurrencyInfo(walletCurrencyInfo);
        }
        return info;
    }

    @Override
    public CurrencyInfo getCurrencyInfo(Currency currency) throws IOException, Exception {
        return this.httpAPIV1.getCurrencyInfo(currency);
    }

    @Override
    public CurrencyInfo getCurrencyInfo(String currencyCode) throws Exception {
        return this.httpAPIV1.getCurrencyInfo(currencyCode);
    }

    private void currencyKludge(DtoBase o) {
        if (o != null && o instanceof CurrencyKludge) {
            ((CurrencyKludge)((Object)o)).setCurrencyInfo(this.currencyInfo);
        }
    }

    @Override
    public OrderCancelResult cancelOrder(MtGoxHTTPClient.OrderType orderType, String orderRef) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (orderType == MtGoxHTTPClient.OrderType.Bid) {
            params.put("type", "2");
        } else {
            params.put("type", "1");
        }
        params.put("oid", orderRef);
        return this.httpAPIV0.cancelOrder(params);
    }

    @Override
    public OrderCancelResult cancelOrder(Order order) throws Exception {
        return this.cancelOrder(order.getType(), order.getOid());
    }

    @Override
    public SendBitcoinsTransaction sendBitcoins(String destinationAddress, MtGoxBitcoin bitcoins, MtGoxBitcoin fee, boolean isNoInstant, boolean isGreen) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("address", destinationAddress);
        params.put("amount_int", String.valueOf(bitcoins.unscaledValue().longValue()));
        params.put("fee_int", String.valueOf(fee.unscaledValue().longValue()));
        params.put("no_instant", isNoInstant ? "1" : "0");
        params.put("green", isGreen ? "1" : "0");
        return this.httpAPIV1.sendBitcoins(params);
    }
}

