/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.service;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jwebsocket.api.WebSocketClientEvent;
import org.jwebsocket.api.WebSocketClientListener;
import org.jwebsocket.api.WebSocketPacket;
import org.jwebsocket.client.java.BaseWebSocket;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import to.sparks.mtgox.MtGoxWebsocketClient;
import to.sparks.mtgox.event.DepthEvent;
import to.sparks.mtgox.event.PacketEvent;
import to.sparks.mtgox.event.TickerEvent;
import to.sparks.mtgox.event.TradeEvent;
import to.sparks.mtgox.model.CurrencyInfo;
import to.sparks.mtgox.model.Depth;
import to.sparks.mtgox.model.DynaBean;
import to.sparks.mtgox.model.OpPrivateDepth;
import to.sparks.mtgox.model.OpPrivateTicker;
import to.sparks.mtgox.model.OpPrivateTrade;
import to.sparks.mtgox.model.Ticker;
import to.sparks.mtgox.model.Trade;
import to.sparks.mtgox.net.MtGoxPacket;
import to.sparks.mtgox.service.HTTPClientV1Service;
import to.sparks.mtgox.service.SocketListener;

class WebsocketClientService
implements Runnable,
MtGoxWebsocketClient,
ApplicationEventPublisherAware,
ApplicationListener<PacketEvent> {
    private ApplicationEventPublisher applicationEventPublisher = null;
    private Logger logger;
    final BaseWebSocket websocket = new BaseWebSocket();
    private ThreadPoolTaskExecutor taskExecutor;
    private Map<String, CurrencyInfo> currencyCache;
    private HTTPClientV1Service httpAPIV1;
    private SocketListener socketListener;

    public WebsocketClientService(Logger logger, ThreadPoolTaskExecutor taskExecutor, HTTPClientV1Service httpAPIV1, SocketListener socketListener) {
        this.logger = logger;
        this.taskExecutor = taskExecutor;
        this.httpAPIV1 = httpAPIV1;
        this.currencyCache = new HashMap<String, CurrencyInfo>();
        this.currencyCache.put("BTC", CurrencyInfo.BitcoinCurrencyInfo);
        this.socketListener = socketListener;
    }

    public void init() {
        this.taskExecutor.execute((Runnable)this);
    }

    public void destroy() {
        try {
            if (this.websocket != null) {
                this.websocket.close();
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void shutdown() {
        this.taskExecutor.shutdown();
    }

    private CurrencyInfo getCachedCurrencyInfo(String currencyCode) {
        CurrencyInfo ci = null;
        if (!this.currencyCache.containsKey(currencyCode)) {
            try {
                ci = this.httpAPIV1.getCurrencyInfo(currencyCode);
                this.currencyCache.put(currencyCode, ci);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, null, ex);
            }
        }
        ci = this.currencyCache.get(currencyCode);
        return ci;
    }

    public void tradeEvent(Trade trade) {
        if (this.applicationEventPublisher != null) {
            CurrencyInfo ci = this.getCachedCurrencyInfo(trade.getPrice_currency());
            if (ci != null) {
                trade.setCurrencyInfo(ci);
            }
            TradeEvent event = new TradeEvent((Object)this, trade);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
        }
    }

    public void tickerEvent(Ticker ticker) {
        if (this.applicationEventPublisher != null) {
            CurrencyInfo ci = this.getCachedCurrencyInfo(ticker.getCurrencyCode());
            if (ci != null) {
                ticker.setCurrencyInfo(ci);
            }
            TickerEvent event = new TickerEvent((Object)this, ticker);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
        }
    }

    public void depthEvent(Depth depth) {
        if (this.applicationEventPublisher != null) {
            DepthEvent event = new DepthEvent((Object)this, depth);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
        }
    }

    @Override
    public void run() {
        try {
            this.websocket.addListener((WebSocketClientListener)this.socketListener);
            this.websocket.open("ws://websocket.mtgox.com/mtgox");
            this.logger.info("WebSocket API Client started.");
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, null, ex);
        }
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onApplicationEvent(PacketEvent event) {
        MtGoxPacket packet = (MtGoxPacket)event.getPayload();
        WebSocketClientEvent aEvent = packet.getaEvent();
        WebSocketPacket aPacket = packet.getaPacket();
        if (aEvent == null) throw new UnsupportedOperationException("Not supported yet.");
        if (aPacket == null || aPacket.getFrameType() != 0) throw new UnsupportedOperationException("Not supported yet.");
        try {
            JsonFactory factory = new JsonFactory();
            ObjectMapper mapper = new ObjectMapper();
            JsonParser jp = factory.createJsonParser(aPacket.getUTF8());
            DynaBean op = (DynaBean)mapper.readValue(jp, DynaBean.class);
            if (op.get("op") != null && op.get("op").equals("private")) {
                String messageType = op.get("private").toString();
                if (messageType.equalsIgnoreCase("ticker")) {
                    OpPrivateTicker opPrivateTicker = (OpPrivateTicker)mapper.readValue(factory.createJsonParser(aPacket.getUTF8()), OpPrivateTicker.class);
                    Ticker ticker = opPrivateTicker.getTicker();
                    this.tickerEvent(ticker);
                    this.logger.log(Level.FINE, "Ticker: last: {0}", new Object[]{ticker.getLast().toPlainString()});
                    return;
                } else if (messageType.equalsIgnoreCase("depth")) {
                    OpPrivateDepth opPrivateDepth = (OpPrivateDepth)mapper.readValue(factory.createJsonParser(aPacket.getUTF8()), OpPrivateDepth.class);
                    Depth depth = opPrivateDepth.getDepth();
                    this.depthEvent(depth);
                    this.logger.log(Level.FINE, "Depth total volume: {0}", new Object[]{depth.getTotalVolume().toPlainString()});
                    return;
                } else if (messageType.equalsIgnoreCase("trade")) {
                    OpPrivateTrade opPrivateTrade = (OpPrivateTrade)mapper.readValue(factory.createJsonParser(aPacket.getUTF8()), OpPrivateTrade.class);
                    Trade trade = opPrivateTrade.getTrade();
                    this.tradeEvent(trade);
                    this.logger.log(Level.FINE, "Trade currency: {0}", new Object[]{trade.getPrice_currency()});
                    return;
                } else {
                    this.logger.log(Level.WARNING, "Unknown private operation: {0}", new Object[]{aPacket.getUTF8()});
                }
                return;
            }
            this.logger.log(Level.WARNING, "Unknown operation: {0}, payload: {1}", new Object[]{op.get("op")});
            return;
        }
        catch (IOException ex) {
            this.logger.log(Level.SEVERE, null, ex);
        }
    }
}

