/*
 * Decompiled with CFR 0.152.
 */
package org.jwebsocket.client.java;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpCookie;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.jwebsocket.api.WebSocketBaseClientEvent;
import org.jwebsocket.api.WebSocketClient;
import org.jwebsocket.api.WebSocketClientEvent;
import org.jwebsocket.api.WebSocketClientListener;
import org.jwebsocket.api.WebSocketPacket;
import org.jwebsocket.api.WebSocketStatus;
import org.jwebsocket.client.java.ReliabilityOptions;
import org.jwebsocket.client.token.WebSocketTokenClientEvent;
import org.jwebsocket.config.JWebSocketCommonConstants;
import org.jwebsocket.kit.Headers;
import org.jwebsocket.kit.RawPacket;
import org.jwebsocket.kit.WebSocketEncoding;
import org.jwebsocket.kit.WebSocketException;
import org.jwebsocket.kit.WebSocketExceptionType;
import org.jwebsocket.kit.WebSocketFrameType;
import org.jwebsocket.kit.WebSocketHandshake;
import org.jwebsocket.kit.WebSocketProtocolAbstraction;
import org.jwebsocket.kit.WebSocketSubProtocol;
import org.jwebsocket.util.Tools;

public class BaseWebSocketClient
implements WebSocketClient {
    private static final int RECEIVER_SHUTDOWN_TIMEOUT = 3000;
    private URI mURI = null;
    private List<WebSocketClientListener> mListeners = new FastList<WebSocketClientListener>();
    private Socket mSocket = null;
    private InputStream mIn = null;
    private OutputStream mOut = null;
    private WebSocketReceiver mReceiver = null;
    protected volatile WebSocketStatus mStatus = WebSocketStatus.CLOSED;
    private List<WebSocketSubProtocol> mSubprotocols;
    private WebSocketSubProtocol mNegotiatedSubProtocol;
    public static String EVENT_OPEN = "open";
    public static String EVENT_CLOSE = "close";
    public static String DATA_CLOSE_ERROR = "error";
    public static String DATA_CLOSE_CLIENT = "client";
    public static String DATA_CLOSE_SERVER = "server";
    public static String DATA_CLOSE_SHUTDOWN = "shutdown";
    private static final String CR_CLIENT = "Client closed connection";
    private int mVersion = 8;
    private WebSocketEncoding mEncoding = WebSocketEncoding.TEXT;
    private ReliabilityOptions mReliabilityOptions = null;
    private final ScheduledThreadPoolExecutor mExecutor = new ScheduledThreadPoolExecutor(1);
    private final Map<String, Object> mParams = new FastMap<String, Object>();
    private final Object mWriteLock = new Object();
    private String mCloseReason = null;
    private ScheduledFuture mReconnectorTask = null;
    private Boolean mIsReconnecting = false;
    private final Object mReconnectLock = new Object();
    private Headers mHeaders = null;
    private List<HttpCookie> mCookies = new ArrayList<HttpCookie>();

    public BaseWebSocketClient() {
    }

    public void setStatus(WebSocketStatus aStatus) throws Exception {
        if (!aStatus.equals((Object)WebSocketStatus.AUTHENTICATED)) {
            throw new Exception("The value '" + aStatus.name() + "' cannot be assigned. Restricted to internal usage only!");
        }
        this.mStatus = aStatus;
    }

    public BaseWebSocketClient(ReliabilityOptions aReliabilityOptions) {
        this.mReliabilityOptions = aReliabilityOptions;
    }

    public Object getParam(String aKey, Object aDefault) {
        Object lValue = this.mParams.get(aKey);
        if (null == lValue) {
            lValue = aDefault;
        }
        return lValue;
    }

    public Object getParam(String aKey) {
        return this.mParams.get(aKey);
    }

    public void setParam(String aKey, Object aValue) {
        this.mParams.put(aKey, aValue);
    }

    @Override
    public void open(String aURI) throws WebSocketException {
        this.open(8, aURI);
    }

    private String generateSubProtocolsHeaderValue() {
        if (this.mSubprotocols == null || this.mSubprotocols.size() <= 0) {
            return JWebSocketCommonConstants.WS_SUBPROT_DEFAULT;
        }
        StringBuilder lBuff = new StringBuilder();
        for (WebSocketSubProtocol lProt : this.mSubprotocols) {
            lBuff.append(lProt.getSubProt()).append(' ');
        }
        return lBuff.toString().trim();
    }

    public void open(int aVersion, String aURI) {
        String lSubProtocols = this.generateSubProtocolsHeaderValue();
        this.open(aVersion, aURI, lSubProtocols);
    }

    public void open(int aVersion, String aURI, String aSubProtocols) {
        try {
            this.mAbortReconnect();
            this.mCloseReason = "Connection could not be established.";
            this.mVersion = aVersion;
            this.mURI = new URI(aURI);
            WebSocketHandshake lHandshake = new WebSocketHandshake(this.mVersion, this.mURI, aSubProtocols);
            if (this.mSocket != null && this.mSocket.isConnected()) {
                this.mSocket.close();
            }
            this.mSocket = this.createSocket();
            this.mSocket.setTcpNoDelay(true);
            this.mIn = this.mSocket.getInputStream();
            this.mOut = this.mSocket.getOutputStream();
            ArrayList<HttpCookie> lTempCookies = new ArrayList<HttpCookie>();
            if (null != this.mCookies) {
                for (int lIndex = 0; lIndex < this.mCookies.size(); ++lIndex) {
                    HttpCookie lCookie = this.mCookies.get(lIndex);
                    boolean lValid = Tools.isCookieValid(this.mURI, lCookie);
                    if (!lValid) continue;
                    lTempCookies.add(lCookie);
                }
            }
            byte[] lBA = lHandshake.generateC2SRequest(lTempCookies);
            this.mOut.write(lBA);
            this.mStatus = WebSocketStatus.CONNECTING;
            this.mHeaders = new Headers();
            try {
                this.mHeaders.readFromStream(aVersion, this.mIn);
            }
            catch (Exception lEx) {
                // empty catch block
            }
            String lSetCookie = this.mHeaders.getField("Set-Cookie");
            if (null != lSetCookie) {
                List<HttpCookie> lCookies = HttpCookie.parse(lSetCookie);
                if (this.mCookies.isEmpty()) {
                    this.mCookies.addAll(lCookies);
                } else {
                    for (HttpCookie lCookie : lCookies) {
                        for (int lIndex = 0; lIndex < this.mCookies.size(); ++lIndex) {
                            if (null != this.mCookies.get(lIndex).getDomain() && (!HttpCookie.domainMatches(this.mCookies.get(lIndex).getDomain(), this.mURI.getHost()) || null != lCookie.getPath() && (null == this.mURI.getPath() || !this.mURI.getPath().startsWith(lCookie.getPath())))) continue;
                            this.mCookies.set(lIndex, lCookie);
                        }
                        if (this.mCookies.contains(lCookie)) continue;
                        this.mCookies.add(lCookie);
                    }
                }
            }
            if (!this.mHeaders.isValid()) {
                WebSocketBaseClientEvent lEvent = new WebSocketBaseClientEvent(this, EVENT_CLOSE, "Handshake rejected.");
                this.notifyClosed(lEvent);
                this.mCheckReconnect(lEvent);
                return;
            }
            String lProtocol = this.mHeaders.getField("Sec-WebSocket-Protocol");
            this.mNegotiatedSubProtocol = lProtocol != null ? new WebSocketSubProtocol(lProtocol, this.mEncoding) : new WebSocketSubProtocol(JWebSocketCommonConstants.WS_SUBPROT_DEFAULT, JWebSocketCommonConstants.WS_ENCODING_DEFAULT);
            this.mReceiver = new WebSocketReceiver(this, this.mIn);
            this.mReceiver.start();
            this.mStatus = WebSocketStatus.OPEN;
            WebSocketBaseClientEvent lEvent = new WebSocketBaseClientEvent(this, EVENT_OPEN, "");
            this.notifyOpened(lEvent);
            this.mCloseReason = null;
        }
        catch (Exception lEx) {
            WebSocketBaseClientEvent lEvent = new WebSocketBaseClientEvent(this, EVENT_CLOSE, this.mCloseReason);
            this.notifyClosed(lEvent);
            this.mCheckReconnect(lEvent);
        }
    }

    private void sendInTransaction(byte[] aData) throws WebSocketException {
        if (this.isHixie()) {
            this.sendInternal(aData);
        } else {
            RawPacket lPacket = new RawPacket(aData);
            lPacket.setFrameType(WebSocketProtocolAbstraction.encodingToFrameType(this.mNegotiatedSubProtocol.getEncoding()));
            this.sendInternal(WebSocketProtocolAbstraction.rawToProtocolPacket(this.mVersion, lPacket));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] aData) throws WebSocketException {
        Object object = this.mWriteLock;
        synchronized (object) {
            this.sendInTransaction(aData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(String aData, String aEncoding) throws WebSocketException {
        Object object = this.mWriteLock;
        synchronized (object) {
            byte[] lData;
            try {
                lData = aData.getBytes(aEncoding);
            }
            catch (UnsupportedEncodingException lEx) {
                throw new WebSocketException("Encoding exception while sending the data:" + lEx.getMessage(), lEx);
            }
            this.send(lData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(WebSocketPacket aDataPacket) throws WebSocketException {
        Object object = this.mWriteLock;
        synchronized (object) {
            if (this.isHixie()) {
                this.sendInternal(aDataPacket.getByteArray());
            } else {
                this.sendInternal(WebSocketProtocolAbstraction.rawToProtocolPacket(this.mVersion, aDataPacket));
            }
        }
    }

    private void sendInternal(byte[] aData) throws WebSocketException {
        if (!this.mStatus.isWritable()) {
            throw new WebSocketException("Error while sending binary data: not connected");
        }
        try {
            if (this.isHixie()) {
                if (WebSocketEncoding.BINARY.equals((Object)this.mNegotiatedSubProtocol.getEncoding())) {
                    this.mOut.write(128);
                    this.mOut.write(aData.length);
                    this.mOut.write(aData);
                } else {
                    this.mOut.write(0);
                    this.mOut.write(aData);
                    this.mOut.write(255);
                }
            } else {
                this.mOut.write(aData);
            }
            this.mOut.flush();
        }
        catch (IOException lEx) {
            this.terminateReceiverThread();
            throw new WebSocketException("Error while sending socket data: ", lEx);
        }
    }

    private void terminateReceiverThread() throws WebSocketException {
        this.mReceiver.quit();
        try {
            this.mReceiver.join(3000L);
        }
        catch (InterruptedException lEx) {
            throw new WebSocketException("Receiver thread did not stop within 3000 ms", lEx);
        }
        this.mReceiver = null;
    }

    private void setCloseReason(String aCloseReason) {
        if (null == this.mCloseReason) {
            this.mCloseReason = aCloseReason;
        }
    }

    @Override
    public synchronized void close() {
        this.mAbortReconnect();
        if (null != this.mReceiver) {
            this.mReceiver.quit();
        }
        if (!this.mStatus.isWritable()) {
            return;
        }
        this.setCloseReason(CR_CLIENT);
        try {
            this.sendCloseHandshake();
        }
        catch (Exception lEx) {
            // empty catch block
        }
        try {
            this.terminateReceiverThread();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCloseHandshake() throws WebSocketException {
        if (!this.mStatus.isClosable()) {
            throw new WebSocketException("Error while sending close handshake: not connected");
        }
        Object object = this.mWriteLock;
        synchronized (object) {
            try {
                if (this.isHixie()) {
                    this.mOut.write(65280);
                    this.mOut.flush();
                } else {
                    RawPacket lPacket = new RawPacket(WebSocketFrameType.CLOSE, "BYE");
                    this.send(lPacket);
                }
            }
            catch (IOException lIOEx) {
                throw new WebSocketException("Error while sending close handshake", lIOEx);
            }
        }
    }

    private Socket createSocket() throws WebSocketException {
        block14: {
            String lScheme = this.mURI.getScheme();
            String lHost = this.mURI.getHost();
            int lPort = this.mURI.getPort();
            this.mSocket = null;
            if (lScheme != null && lScheme.equals("ws")) {
                if (lPort == -1) {
                    lPort = 80;
                }
                try {
                    this.mSocket = new Socket(lHost, lPort);
                }
                catch (UnknownHostException lUHEx) {
                    throw new WebSocketException("Unknown host: " + lHost, WebSocketExceptionType.UNKNOWN_HOST, lUHEx);
                }
                catch (IOException lIOEx) {
                    throw new WebSocketException("Error while creating socket to " + this.mURI, WebSocketExceptionType.UNABLE_TO_CONNECT, lIOEx);
                }
            }
            if (lScheme != null && lScheme.equals("wss")) {
                if (lPort == -1) {
                    lPort = 443;
                }
                try {
                    try {
                        TrustManager[] lTrustManager = new TrustManager[]{new X509TrustManager(){

                            @Override
                            public X509Certificate[] getAcceptedIssuers() {
                                return null;
                            }

                            @Override
                            public void checkClientTrusted(X509Certificate[] aCerts, String aAuthType) {
                            }

                            @Override
                            public void checkServerTrusted(X509Certificate[] aCerts, String aAuthType) {
                            }
                        }};
                        SSLContext lSSLContext = SSLContext.getInstance("TLS");
                        lSSLContext.init(null, lTrustManager, new SecureRandom());
                        this.mSocket = (SSLSocket)lSSLContext.getSocketFactory().createSocket(lHost, lPort);
                        break block14;
                    }
                    catch (NoSuchAlgorithmException lNSAEx) {
                        throw new RuntimeException("Unable to initialize SSL context", lNSAEx);
                    }
                    catch (KeyManagementException lKMEx) {
                        throw new RuntimeException("Unable to initialize SSL context", lKMEx);
                    }
                }
                catch (UnknownHostException lUHEx) {
                    throw new WebSocketException("Unknown host: " + lHost, WebSocketExceptionType.UNKNOWN_HOST, lUHEx);
                }
                catch (IOException lIOEx) {
                    throw new WebSocketException("Error while creating secure socket to " + this.mURI, WebSocketExceptionType.UNABLE_TO_CONNECT_SSL, lIOEx);
                }
                catch (Exception lEx) {
                    throw new WebSocketException(lEx.getClass().getSimpleName() + " while creating secure socket to " + this.mURI, lEx);
                }
            }
            throw new WebSocketException("Unsupported protocol: " + lScheme, WebSocketExceptionType.PROTOCOL_NOT_SUPPORTED);
        }
        return this.mSocket;
    }

    @Override
    public boolean isConnected() {
        return this.mStatus.isConnected();
    }

    @Override
    public WebSocketStatus getStatus() {
        return this.mStatus;
    }

    public WebSocketStatus getConnectionStatus() {
        return this.mStatus;
    }

    public Socket getConnectionSocket() {
        return this.mSocket;
    }

    @Override
    public void addListener(WebSocketClientListener aListener) {
        this.mListeners.add(aListener);
    }

    @Override
    public void removeListener(WebSocketClientListener aListener) {
        this.mListeners.remove(aListener);
    }

    @Override
    public List<WebSocketClientListener> getListeners() {
        return Collections.unmodifiableList(this.mListeners);
    }

    @Override
    public void notifyOpened(WebSocketClientEvent aEvent) {
        for (WebSocketClientListener lListener : this.getListeners()) {
            lListener.processOpened(aEvent);
        }
    }

    @Override
    public void notifyPacket(WebSocketClientEvent aEvent, WebSocketPacket aPacket) {
        for (WebSocketClientListener lListener : this.getListeners()) {
            lListener.processPacket(aEvent, aPacket);
        }
    }

    @Override
    public void notifyReconnecting(WebSocketClientEvent aEvent) {
        for (WebSocketClientListener lListener : this.getListeners()) {
            lListener.processReconnecting(aEvent);
        }
    }

    public ReliabilityOptions getReliabilityOptions() {
        return this.mReliabilityOptions;
    }

    public void setReliabilityOptions(ReliabilityOptions mReliabilityOptions) {
        this.mReliabilityOptions = mReliabilityOptions;
    }

    public Headers getHeaders() {
        return this.mHeaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mAbortReconnect() {
        Object object = this.mReconnectLock;
        synchronized (object) {
            if (null != this.mReconnectorTask) {
                this.mReconnectorTask.cancel(true);
            }
            this.mIsReconnecting = false;
            this.mReconnectorTask = null;
            this.mExecutor.purge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mCheckReconnect(WebSocketClientEvent aEvent) {
        Object object = this.mReconnectLock;
        synchronized (object) {
            this.mExecutor.purge();
            if (this.mReliabilityOptions != null && this.mReliabilityOptions.getReconnectDelay() > 0L && !this.mIsReconnecting.booleanValue()) {
                this.mIsReconnecting = true;
                this.mReconnectorTask = this.mExecutor.schedule(new ReOpener(aEvent), this.mReliabilityOptions.getReconnectDelay(), TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public void notifyClosed(WebSocketClientEvent aEvent) {
        for (WebSocketClientListener lListener : this.getListeners()) {
            lListener.processClosed(aEvent);
        }
    }

    @Override
    public void addSubProtocol(WebSocketSubProtocol aSubProt) {
        if (this.mSubprotocols == null) {
            this.mSubprotocols = new ArrayList<WebSocketSubProtocol>(3);
        }
        this.mSubprotocols.add(aSubProt);
    }

    @Override
    public String getNegotiatedSubProtocol() {
        return this.mNegotiatedSubProtocol == null ? null : this.mNegotiatedSubProtocol.getSubProt();
    }

    @Override
    public WebSocketEncoding getNegotiatedEncoding() {
        return this.mNegotiatedSubProtocol == null ? null : this.mNegotiatedSubProtocol.getEncoding();
    }

    @Override
    public void setVersion(int aVersion) {
        this.mVersion = aVersion;
    }

    private boolean isHixie() {
        return WebSocketProtocolAbstraction.isHixieVersion(this.mVersion);
    }

    class WebSocketReceiver
    extends Thread {
        private WebSocketClient mClient = null;
        private InputStream mIS = null;
        private volatile boolean mIsRunning = false;

        public WebSocketReceiver(WebSocketClient aClient, InputStream aInput) {
            this.mClient = aClient;
            this.mIS = aInput;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("jWebSocket-Client " + this.getId());
            this.mIsRunning = true;
            if (BaseWebSocketClient.this.isHixie()) {
                this.processHixie();
            } else {
                this.processHybi();
            }
            BaseWebSocketClient.this.mStatus = WebSocketStatus.CLOSING;
            String lExMsg = "";
            try {
                if (!(BaseWebSocketClient.this.mSocket instanceof SSLSocket) && !BaseWebSocketClient.this.mSocket.isOutputShutdown()) {
                    BaseWebSocketClient.this.mSocket.shutdownInput();
                }
            }
            catch (IOException lIOEx) {
                lExMsg = lExMsg + "Shutdown input: " + lIOEx.getMessage() + ", ";
            }
            try {
                if (!(BaseWebSocketClient.this.mSocket instanceof SSLSocket) && !BaseWebSocketClient.this.mSocket.isOutputShutdown()) {
                    BaseWebSocketClient.this.mSocket.shutdownOutput();
                }
            }
            catch (IOException lIOEx) {
                lExMsg = lExMsg + "Shutdown output: " + lIOEx.getMessage() + ", ";
            }
            try {
                if (!BaseWebSocketClient.this.mSocket.isClosed()) {
                    BaseWebSocketClient.this.mSocket.close();
                }
            }
            catch (IOException lIOEx) {
                lExMsg = lExMsg + "Socket close: " + lIOEx.getMessage() + ", ";
            }
            BaseWebSocketClient.this.mStatus = WebSocketStatus.CLOSED;
            WebSocketBaseClientEvent lEvent = new WebSocketBaseClientEvent(this.mClient, EVENT_CLOSE, BaseWebSocketClient.this.mCloseReason);
            BaseWebSocketClient.this.notifyClosed(lEvent);
            this.quit();
            if (!BaseWebSocketClient.CR_CLIENT.equals(BaseWebSocketClient.this.mCloseReason)) {
                BaseWebSocketClient.this.mCheckReconnect(lEvent);
            }
        }

        private void processHixie() {
            boolean lFrameStart = false;
            ByteArrayOutputStream lBuff = new ByteArrayOutputStream();
            while (this.mIsRunning) {
                try {
                    int lB = this.mIS.read();
                    if (lB == 0) {
                        lFrameStart = true;
                        continue;
                    }
                    if (lB == 255 && lFrameStart) {
                        lFrameStart = false;
                        WebSocketTokenClientEvent lWSCE = new WebSocketTokenClientEvent(this.mClient, null, null);
                        RawPacket lPacket = new RawPacket(lBuff.toByteArray());
                        lBuff.reset();
                        BaseWebSocketClient.this.notifyPacket(lWSCE, lPacket);
                        continue;
                    }
                    if (lFrameStart) {
                        lBuff.write(lB);
                        continue;
                    }
                    if (lB != -1) continue;
                    BaseWebSocketClient.this.setCloseReason("Inbound stream terminated");
                    this.mIsRunning = false;
                }
                catch (Exception lEx) {
                    this.mIsRunning = false;
                    BaseWebSocketClient.this.setCloseReason(lEx.getClass().getName() + " in hybi processor: " + lEx.getMessage());
                }
            }
        }

        private void processHybi() {
            while (this.mIsRunning) {
                try {
                    WebSocketFrameType lFrameType;
                    WebSocketPacket lPacket = WebSocketProtocolAbstraction.protocolToRawPacket(BaseWebSocketClient.this.mVersion, this.mIS);
                    WebSocketFrameType webSocketFrameType = lFrameType = lPacket != null ? lPacket.getFrameType() : WebSocketFrameType.INVALID;
                    if (null == lFrameType) {
                        if (this.mIsRunning) {
                            BaseWebSocketClient.this.setCloseReason("Connection broken");
                        } else {
                            BaseWebSocketClient.this.setCloseReason("Client terminated");
                        }
                        this.mIsRunning = false;
                        continue;
                    }
                    if (WebSocketFrameType.INVALID == lFrameType) {
                        this.mIsRunning = false;
                        BaseWebSocketClient.this.setCloseReason("Invalid hybi frame type detected");
                        continue;
                    }
                    if (WebSocketFrameType.CLOSE == lFrameType) {
                        this.mIsRunning = false;
                        BaseWebSocketClient.this.setCloseReason("Server closed connection");
                        continue;
                    }
                    if (WebSocketFrameType.PING == lFrameType) {
                        RawPacket lPong = new RawPacket(WebSocketFrameType.PONG, "");
                        BaseWebSocketClient.this.send(lPong);
                        continue;
                    }
                    if (WebSocketFrameType.PONG == lFrameType || WebSocketFrameType.TEXT != lFrameType) continue;
                    WebSocketTokenClientEvent lWSCE = new WebSocketTokenClientEvent(this.mClient, null, null);
                    BaseWebSocketClient.this.notifyPacket(lWSCE, lPacket);
                }
                catch (Exception lEx) {
                    this.mIsRunning = false;
                    BaseWebSocketClient.this.setCloseReason(lEx.getClass().getName() + " in hybi processor: " + lEx.getMessage());
                }
            }
        }

        public void quit() {
            this.mIsRunning = false;
            try {
                this.mIS.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public boolean isRunning() {
            return this.mIsRunning;
        }
    }

    class ReOpener
    implements Runnable {
        private WebSocketClientEvent mEvent;

        public ReOpener(WebSocketClientEvent aEvent) {
            this.mEvent = aEvent;
        }

        @Override
        public void run() {
            BaseWebSocketClient.this.mIsReconnecting = false;
            BaseWebSocketClient.this.notifyReconnecting(this.mEvent);
            try {
                BaseWebSocketClient.this.open(BaseWebSocketClient.this.mURI.toString());
            }
            catch (Exception lEx) {
                WebSocketBaseClientEvent lEvent = new WebSocketBaseClientEvent(this.mEvent.getClient(), EVENT_CLOSE, lEx.getClass().getSimpleName() + ": " + lEx.getMessage());
                BaseWebSocketClient.this.notifyClosed(lEvent);
            }
        }
    }
}

