/*
 * Decompiled with CFR 0.152.
 */
package org.jwebsocket.client.token;

import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javolution.util.FastMap;
import org.apache.commons.codec.binary.Base64;
import org.jwebsocket.api.WebSocketClientEvent;
import org.jwebsocket.api.WebSocketClientListener;
import org.jwebsocket.api.WebSocketClientTokenListener;
import org.jwebsocket.api.WebSocketPacket;
import org.jwebsocket.api.WebSocketStatus;
import org.jwebsocket.api.WebSocketTokenClient;
import org.jwebsocket.client.java.BaseWebSocketClient;
import org.jwebsocket.client.java.ReliabilityOptions;
import org.jwebsocket.config.JWebSocketCommonConstants;
import org.jwebsocket.kit.WebSocketEncoding;
import org.jwebsocket.kit.WebSocketException;
import org.jwebsocket.kit.WebSocketSubProtocol;
import org.jwebsocket.packetProcessors.CSVProcessor;
import org.jwebsocket.packetProcessors.JSONProcessor;
import org.jwebsocket.packetProcessors.XMLProcessor;
import org.jwebsocket.token.PendingResponseQueueItem;
import org.jwebsocket.token.Token;
import org.jwebsocket.token.TokenFactory;
import org.jwebsocket.token.WebSocketResponseTokenListener;
import org.jwebsocket.util.Tools;

public class BaseTokenClient
extends BaseWebSocketClient
implements WebSocketTokenClient {
    private static final String NS_BASE = "org.jwebsocket";
    private static final String WELCOME = "welcome";
    private static final String LOGIN = "login";
    private static final String SPRING_LOGON = "logon";
    private static final String SPRING_LOGOFF = "logoff";
    private static final String GOODBYE = "goodBye";
    private static final String LOGOUT = "logout";
    private int CUR_TOKEN_ID = 0;
    private WebSocketSubProtocol mSubProt = null;
    private String mUsername = null;
    private String fClientId = null;
    private final Map<Integer, PendingResponseQueueItem> mPendingResponseQueue = new FastMap().shared();
    private final ScheduledThreadPoolExecutor mResponseQueueExecutor = new ScheduledThreadPoolExecutor(1);
    private static final String NS_SYSTEM_PLUGIN = "org.jwebsocket.plugins.system";
    private static final String NS_FILESYSTEM_PLUGIN = "org.jwebsocket.plugins.filesystem";
    private static final String NS_ADMIN_PLUGIN = "org.jwebsocket.plugins.admin";

    public BaseTokenClient() {
        this(JWebSocketCommonConstants.WS_SUBPROT_DEFAULT, JWebSocketCommonConstants.WS_ENCODING_DEFAULT);
    }

    public BaseTokenClient(ReliabilityOptions aReliabilityOptions) {
        this(JWebSocketCommonConstants.WS_SUBPROT_DEFAULT, JWebSocketCommonConstants.WS_ENCODING_DEFAULT);
        this.setReliabilityOptions(aReliabilityOptions);
    }

    public BaseTokenClient(String aSubProt, WebSocketEncoding aEncoding) {
        this.mSubProt = new WebSocketSubProtocol(aSubProt, aEncoding);
        this.addSubProtocol(this.mSubProt);
        this.addListener(new TokenClientListener());
    }

    public BaseTokenClient(WebSocketSubProtocol aSubProt) {
        this.mSubProt = aSubProt;
        this.addSubProtocol(this.mSubProt);
        this.addListener(new TokenClientListener());
    }

    @Override
    public void addTokenClientListener(WebSocketClientTokenListener aTokenListener) {
        super.addListener(aTokenListener);
    }

    @Override
    public void removeTokenClientListener(WebSocketClientTokenListener aTokenListener) {
        super.removeListener(aTokenListener);
    }

    @Override
    public void close() {
        super.close();
        this.mUsername = null;
        this.fClientId = null;
    }

    @Override
    public String getUsername() {
        return this.mUsername;
    }

    public void setUsername(String aUsername) {
        this.mUsername = aUsername;
    }

    @Override
    public boolean isAuthenticated() {
        return this.mUsername != null;
    }

    public String getClientId() {
        return this.fClientId;
    }

    public Token packetToToken(WebSocketPacket aPacket) {
        Token lToken = null;
        if ("json".equals(this.mSubProt.getFormat())) {
            lToken = JSONProcessor.packetToToken(aPacket);
        } else if ("csv".equals(this.mSubProt.getFormat())) {
            lToken = CSVProcessor.packetToToken(aPacket);
        } else if ("xml".equals(this.mSubProt.getFormat())) {
            lToken = XMLProcessor.packetToToken(aPacket);
        }
        return lToken;
    }

    public WebSocketPacket tokenToPacket(Token aToken) {
        WebSocketPacket lPacket = null;
        if ("json".equals(this.mSubProt.getFormat())) {
            lPacket = JSONProcessor.tokenToPacket(aToken);
        } else if ("csv".equals(this.mSubProt.getFormat())) {
            lPacket = CSVProcessor.tokenToPacket(aToken);
        } else if ("xml".equals(this.mSubProt.getFormat())) {
            lPacket = XMLProcessor.tokenToPacket(aToken);
        }
        return lPacket;
    }

    public void sendToken(Token aToken) throws WebSocketException {
        ++this.CUR_TOKEN_ID;
        aToken.setInteger("utid", this.CUR_TOKEN_ID);
        super.send(this.tokenToPacket(aToken));
    }

    public void sendToken(Token aToken, WebSocketResponseTokenListener aResponseListener) throws WebSocketException {
        PendingResponseQueueItem lPRQI = new PendingResponseQueueItem(aToken, aResponseListener);
        int lUTID = this.CUR_TOKEN_ID + 1;
        this.mPendingResponseQueue.put(lUTID, lPRQI);
        ResponseTimeoutTimer lRTT = new ResponseTimeoutTimer(lUTID);
        this.mResponseQueueExecutor.schedule(lRTT, aResponseListener.getTimeout(), TimeUnit.MILLISECONDS);
        this.sendToken(aToken);
    }

    @Override
    public void login(String aUsername, String aPassword) throws WebSocketException {
        Token lToken = TokenFactory.createToken(NS_SYSTEM_PLUGIN, LOGIN);
        lToken.setString("username", aUsername);
        lToken.setString("password", aPassword);
        this.sendToken(lToken);
    }

    @Override
    public void logout() throws WebSocketException {
        Token lToken = TokenFactory.createToken(NS_SYSTEM_PLUGIN, LOGOUT);
        this.sendToken(lToken);
    }

    @Override
    public void ping(boolean aEcho) throws WebSocketException {
        Token lToken = TokenFactory.createToken(NS_SYSTEM_PLUGIN, "ping");
        lToken.setBoolean("echo", aEcho);
        this.sendToken(lToken);
    }

    @Override
    public void sendText(String aTarget, String aData) throws WebSocketException {
        Token lToken = TokenFactory.createToken(NS_SYSTEM_PLUGIN, "send");
        lToken.setString("targetId", aTarget);
        lToken.setString("sourceId", this.getClientId());
        lToken.setString("sender", this.getUsername());
        lToken.setString("data", aData);
        this.sendToken(lToken);
    }

    @Override
    public void broadcastText(String aData) throws WebSocketException {
        Token lToken = TokenFactory.createToken(NS_SYSTEM_PLUGIN, "broadcast");
        lToken.setString("sourceId", this.getClientId());
        lToken.setString("sender", this.getUsername());
        lToken.setString("data", aData);
        lToken.setBoolean("senderIncluded", false);
        lToken.setBoolean("responseRequested", true);
        this.sendToken(lToken);
    }

    public void saveFile(byte[] aData, String aFilename, String aScope, Boolean aNotify) throws WebSocketException {
        Token lToken = TokenFactory.createToken(NS_FILESYSTEM_PLUGIN, "save");
        lToken.setString("sourceId", this.getClientId());
        lToken.setString("sender", this.getUsername());
        lToken.setString("filename", aFilename);
        lToken.setString("mimetype", "image/jpeg");
        lToken.setString("scope", aScope);
        lToken.setBoolean("notify", aNotify);
        lToken.setString("data", Tools.base64Encode(aData));
        this.sendToken(lToken);
    }

    public void sendFile(String aHeader, byte[] aData, String aFilename, String aTarget) throws WebSocketException {
        Token lToken = TokenFactory.createToken(NS_FILESYSTEM_PLUGIN, "send");
        lToken.setString("sourceId", this.getClientId());
        lToken.setString("sender", this.getUsername());
        lToken.setString("filename", aFilename);
        lToken.setString("mimetype", "image/jpeg");
        lToken.setString("unid", aTarget);
        lToken.setString("data", aHeader + new String(Base64.encodeBase64(aData)));
        this.sendToken(lToken);
    }

    @Override
    public void disconnect() throws WebSocketException {
    }

    public void shutdown() throws WebSocketException {
        Token lToken = TokenFactory.createToken(NS_ADMIN_PLUGIN, "shutdown");
        this.sendToken(lToken);
    }

    @Override
    public void getConnections() throws WebSocketException {
        Token lToken = TokenFactory.createToken(NS_ADMIN_PLUGIN, "getConnections");
        this.sendToken(lToken);
    }

    public void getUserRights(String aUsername) throws WebSocketException {
        Token lToken = TokenFactory.createToken(NS_ADMIN_PLUGIN, "getUserRights");
        lToken.setString("username", aUsername);
        this.sendToken(lToken);
    }

    public void getUserRoles(String aUsername) throws WebSocketException {
        Token lToken = TokenFactory.createToken(NS_ADMIN_PLUGIN, "getUserRoles");
        lToken.setString("username", aUsername);
        this.sendToken(lToken);
    }

    private class ResponseTimeoutTimer
    implements Runnable {
        private Integer mUTID = 0;

        public ResponseTimeoutTimer(Integer aUTID) {
            this.mUTID = aUTID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map = BaseTokenClient.this.mPendingResponseQueue;
            synchronized (map) {
                PendingResponseQueueItem lPRQI;
                PendingResponseQueueItem pendingResponseQueueItem = lPRQI = this.mUTID != null ? (PendingResponseQueueItem)BaseTokenClient.this.mPendingResponseQueue.get(this.mUTID) : null;
                if (lPRQI != null) {
                    WebSocketResponseTokenListener lWSRTL = lPRQI.getListener();
                    if (lWSRTL != null) {
                        lWSRTL.OnTimeout(lPRQI.getToken());
                    }
                    BaseTokenClient.this.mPendingResponseQueue.remove(this.mUTID);
                }
            }
        }
    }

    class TokenClientListener
    implements WebSocketClientListener {
        TokenClientListener() {
        }

        @Override
        public void processOpening(WebSocketClientEvent aEvent) {
        }

        @Override
        public void processOpened(WebSocketClientEvent aEvent) {
            BaseTokenClient.this.mUsername = null;
            BaseTokenClient.this.fClientId = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processPacket(WebSocketClientEvent aEvent, WebSocketPacket aPacket) {
            Object lUsername;
            Token lToken = BaseTokenClient.this.packetToToken(aPacket);
            String lType = lToken.getType();
            String lReqType = lToken.getString("reqType");
            if (lType != null) {
                if (BaseTokenClient.WELCOME.equals(lType)) {
                    BaseTokenClient.this.fClientId = lToken.getString("sourceId");
                    lUsername = lToken.getString("username");
                    if (null != lUsername && !((String)lUsername).equals("anonymous")) {
                        BaseTokenClient.this.mUsername = (String)lUsername;
                        BaseTokenClient.this.mStatus = WebSocketStatus.AUTHENTICATED;
                    }
                } else if (BaseTokenClient.GOODBYE.equals(lType)) {
                    BaseTokenClient.this.mUsername = null;
                }
            }
            if (lReqType != null) {
                if (BaseTokenClient.LOGIN.equals(lReqType) || BaseTokenClient.SPRING_LOGON.equals(lReqType)) {
                    BaseTokenClient.this.mUsername = lToken.getString("username");
                    BaseTokenClient.this.mStatus = WebSocketStatus.AUTHENTICATED;
                } else if (BaseTokenClient.LOGOUT.equals(lReqType) || BaseTokenClient.SPRING_LOGOFF.equals(lReqType)) {
                    BaseTokenClient.this.mStatus = WebSocketStatus.OPEN;
                    BaseTokenClient.this.mUsername = null;
                }
            }
            lUsername = BaseTokenClient.this.mPendingResponseQueue;
            synchronized (lUsername) {
                PendingResponseQueueItem lPRQI;
                Integer lUTID = lToken.getInteger("utid");
                Integer lCode = lToken.getInteger("code");
                PendingResponseQueueItem pendingResponseQueueItem = lPRQI = lUTID != null ? (PendingResponseQueueItem)BaseTokenClient.this.mPendingResponseQueue.get(lUTID) : null;
                if (lPRQI != null) {
                    WebSocketResponseTokenListener lWSRTL = lPRQI.getListener();
                    if (lWSRTL != null) {
                        lWSRTL.OnResponse(lToken);
                        if (lCode != null) {
                            if (lCode == 0) {
                                lWSRTL.OnSuccess(lToken);
                            } else {
                                lWSRTL.OnFailure(lToken);
                            }
                        }
                    }
                    BaseTokenClient.this.mPendingResponseQueue.remove(lUTID);
                }
            }
            for (WebSocketClientListener lListener : BaseTokenClient.this.getListeners()) {
                if (!(lListener instanceof WebSocketClientTokenListener)) continue;
                ((WebSocketClientTokenListener)lListener).processToken(aEvent, lToken);
            }
        }

        @Override
        public void processClosed(WebSocketClientEvent aEvent) {
            BaseTokenClient.this.mUsername = null;
            BaseTokenClient.this.fClientId = null;
        }

        @Override
        public void processReconnecting(WebSocketClientEvent aEvent) {
        }
    }
}

