/*
 * Decompiled with CFR 0.152.
 */
package org.jwebsocket.kit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javolution.util.FastMap;
import org.jwebsocket.kit.WebSocketException;
import org.jwebsocket.kit.WebSocketProtocolAbstraction;

public class Headers {
    public static final String HOST = "Host";
    public static final String UPGRADE = "Upgrade";
    public static final String CONNECTION = "Connection";
    public static final String SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key";
    public static final String SEC_WEBSOCKET_ORIGIN = "Sec-WebSocket-Origin";
    public static final String SEC_WEBSOCKET_PROTOCOL = "Sec-WebSocket-Protocol";
    public static final String SEC_WEBSOCKET_VERSION = "Sec-WebSocket-Version";
    public static final String SEC_WEBSOCKET_ACCEPT = "Sec-WebSocket-Accept";
    private Map<String, String> mFields = new FastMap<String, String>();
    private String mFirstLine = null;
    private byte[] mTrailingBytes = null;

    public void readFromStream(int aVersion, InputStream aIS) throws WebSocketException {
        boolean lHeaderComplete = false;
        boolean lInHeader = true;
        int lLineNo = 0;
        ByteArrayOutputStream lBuffer = new ByteArrayOutputStream(512);
        ByteArrayOutputStream lTrailing = new ByteArrayOutputStream(16);
        int lB = -1;
        while (!lHeaderComplete) {
            String lLine;
            int lA = lB;
            try {
                lB = aIS.read();
            }
            catch (IOException ex) {
                throw new WebSocketException("Error on reading stream: " + ex.getMessage());
            }
            if (lB < 0) {
                return;
            }
            lBuffer.write(lB);
            if (!lInHeader) {
                lTrailing.write(lB);
                if (lTrailing.size() != 16) continue;
                lHeaderComplete = true;
                continue;
            }
            if (13 != lA || 10 != lB) continue;
            try {
                lLine = lBuffer.toString("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new WebSocketException("Error on on converting string: " + ex.getMessage());
            }
            if (lLine.trim().equals("")) {
                lInHeader = false;
                lHeaderComplete = !WebSocketProtocolAbstraction.isHixieVersion(aVersion);
            } else {
                if (0 == lLineNo) {
                    this.mFirstLine = lLine;
                } else {
                    String[] lKeyVal = lLine.split(":", 2);
                    if (2 == lKeyVal.length) {
                        this.mFields.put(lKeyVal[0].trim(), lKeyVal[1].trim());
                    }
                }
                ++lLineNo;
            }
            lBuffer.reset();
        }
    }

    public Map<String, String> getFields() {
        return this.mFields;
    }

    public String getField(String aField) {
        if (null != this.mFields) {
            return this.mFields.get(aField);
        }
        return null;
    }

    public String getFirstLine() {
        return this.mFirstLine;
    }

    public byte[] getTrailingBytes() {
        return this.mTrailingBytes;
    }

    public boolean isValid() {
        return this.mFirstLine != null && this.mFields.size() > 0;
    }
}

