/*
 * Decompiled with CFR 0.152.
 */
package org.jwebsocket.kit;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.jwebsocket.api.WebSocketPacket;
import org.jwebsocket.kit.WebSocketFrameType;

public class RawPacket
implements WebSocketPacket {
    private byte[] mData = null;
    private String[] mFragments = null;
    private int mFragmentsLoaded = 0;
    private int mFragmentsExpected = 0;
    private boolean mIsFragmented = false;
    private boolean mIsComplete = false;
    private Date mCreationDate = null;
    private long mTimeout = 0L;
    private WebSocketFrameType mFrameType = WebSocketFrameType.TEXT;

    public RawPacket(int aInitialSize) {
        this.initFragmented(aInitialSize);
    }

    public RawPacket(byte[] aByteArray) {
        this.setByteArray(aByteArray);
    }

    public RawPacket(WebSocketFrameType aFrameType, byte[] aByteArray) {
        this.setFrameType(aFrameType);
        this.setByteArray(aByteArray);
    }

    public RawPacket(String aString) {
        this.setString(aString);
    }

    public RawPacket(WebSocketFrameType aFrameType, String aString) {
        this.setFrameType(aFrameType);
        this.setString(aString);
    }

    public RawPacket(String aString, String aEncoding) throws UnsupportedEncodingException {
        this.setString(aString, aEncoding);
    }

    @Override
    public final void setByteArray(byte[] aByteArray) {
        this.mData = aByteArray;
    }

    @Override
    public final void setString(String aString) {
        this.mData = aString.getBytes();
    }

    @Override
    public final void setString(String aString, String aEncoding) throws UnsupportedEncodingException {
        this.mData = aString.getBytes(aEncoding);
    }

    @Override
    public final void setUTF8(String aString) {
        try {
            this.mData = aString.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public final void setASCII(String aString) {
        try {
            this.mData = aString.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public final byte[] getByteArray() {
        return this.mData;
    }

    @Override
    public final String getString() {
        return new String(this.mData);
    }

    @Override
    public final String getString(String aEncoding) throws UnsupportedEncodingException {
        return new String(this.mData, aEncoding);
    }

    @Override
    public final String getUTF8() {
        try {
            return new String(this.mData, "UTF-8");
        }
        catch (UnsupportedEncodingException lEx) {
            return null;
        }
    }

    @Override
    public final String getASCII() {
        try {
            return new String(this.mData, "US-ASCII");
        }
        catch (UnsupportedEncodingException lEx) {
            return null;
        }
    }

    @Override
    public final WebSocketFrameType getFrameType() {
        return this.mFrameType;
    }

    @Override
    public final void setFrameType(WebSocketFrameType aFrameType) {
        this.mFrameType = aFrameType;
    }

    @Override
    public final boolean isFragmented() {
        return this.mIsFragmented;
    }

    @Override
    public final boolean isComplete() {
        return this.mIsComplete;
    }

    @Override
    public final void setFragment(String aString, int aIdx) {
        this.mFragments[aIdx] = aString;
        ++this.mFragmentsLoaded;
        this.mIsComplete = this.mFragmentsLoaded >= this.mFragmentsExpected;
    }

    @Override
    public void packFragments() {
        StringBuilder lSB = new StringBuilder();
        for (int lIdx = 0; lIdx < this.mFragments.length; ++lIdx) {
            lSB.append(this.mFragments[lIdx]);
            this.mFragments[lIdx] = null;
        }
        try {
            this.mData = lSB.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public final void initFragmented(int aTotal) {
        this.mFragmentsExpected = aTotal;
        this.mFragments = new String[aTotal];
    }

    @Override
    public final void setCreationDate(Date aDate) {
        this.mCreationDate = aDate;
    }

    @Override
    public final Date getCreationDate() {
        return this.mCreationDate;
    }

    @Override
    public final void setTimeout(long aMilliseconds) {
        this.mTimeout = aMilliseconds;
    }

    @Override
    public final boolean isTimedOut() {
        return this.mCreationDate.getTime() + this.mTimeout < new Date().getTime();
    }
}

