/*
 * Decompiled with CFR 0.152.
 */
package org.jwebsocket.kit;

import java.util.Map;
import javolution.util.FastMap;
import org.jwebsocket.config.JWebSocketCommonConstants;

public final class RequestHeader {
    private Map<String, Object> mFields = new FastMap<String, Object>();
    public static final String WS_PROTOCOL = "subprot";
    public static final String WS_DRAFT = "draft";
    public static final String WS_VERSION = "version";
    public static final String WS_ORIGIN = "origin";
    public static final String WS_LOCATION = "location";
    public static final String WS_PATH = "path";
    public static final String WS_SEARCHSTRING = "searchString";
    public static final String WS_HOST = "host";
    public static final String WS_SECKEY = "secKey";
    public static final String WS_SECKEY1 = "secKey1";
    public static final String WS_SECKEY2 = "secKey2";
    public static final String WS_COOKIES = "cookie";
    public static final String URL_ARGS = "args";
    public static final String TIMEOUT = "timeout";
    public static final String USER_AGENT = "User-Agent";

    public void put(String aKey, Object aValue) {
        this.mFields.put(aKey, aValue);
    }

    public Object get(String aKey) {
        return this.mFields.get(aKey);
    }

    public String getString(String aKey) {
        return (String)this.mFields.get(aKey);
    }

    public Map getArgs() {
        return (Map)this.mFields.get(URL_ARGS);
    }

    public String getSubProtocol() {
        return this.resolveSubprotocol()[0];
    }

    public String getFormat() {
        return this.resolveSubprotocol()[1];
    }

    private String[] resolveSubprotocol() {
        String lSubProt = (String)this.mFields.get(WS_PROTOCOL);
        if (lSubProt == null) {
            lSubProt = JWebSocketCommonConstants.WS_SUBPROT_DEFAULT;
        }
        if (lSubProt.indexOf(47) != -1) {
            return lSubProt.split("/");
        }
        String lFormat = JWebSocketCommonConstants.WS_FORMAT_DEFAULT;
        if ("org.jwebsocket.json".equals(lSubProt)) {
            lFormat = "json";
        } else if ("org.jwebsocket.xml".equals(lSubProt)) {
            lFormat = "xml";
        } else if ("org.jwebsocket.csv".equals(lSubProt)) {
            lFormat = "csv";
        } else if ("org.jwebsocket.text".equals(lSubProt)) {
            lFormat = "text";
        } else if ("org.jwebsocket.binary".equals(lSubProt)) {
            lFormat = "binary";
        }
        return new String[]{lSubProt, lFormat};
    }

    public Integer getTimeout(Integer aDefault) {
        Map lArgs = this.getArgs();
        Integer lTimeout = null;
        if (lArgs != null) {
            try {
                lTimeout = Integer.parseInt((String)lArgs.get(TIMEOUT));
            }
            catch (Exception lEx) {
                // empty catch block
            }
        }
        return lTimeout != null ? lTimeout : aDefault;
    }

    public int getVersion() {
        return (Integer)this.mFields.get(WS_VERSION);
    }

    public Map getCookies() {
        return (Map)this.get(WS_COOKIES);
    }
}

