/*
 * Decompiled with CFR 0.152.
 */
package org.jwebsocket.kit;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jwebsocket.kit.Headers;
import org.jwebsocket.kit.WebSocketException;
import org.jwebsocket.kit.WebSocketProtocolAbstraction;
import org.jwebsocket.util.Tools;

public final class WebSocketHandshake {
    public static int MAX_HEADER_SIZE = 16834;
    private String mHybiKey = null;
    private String mHybiKeyAccept = null;
    private String mHixieKey1 = null;
    private String mHixieKey2 = null;
    private byte[] mHixieKey3 = null;
    private byte[] mHixieKeyAccept = null;
    private URI mURI = null;
    private String mOrigin = null;
    private String mProtocol = null;
    private Integer mVersion = null;

    public WebSocketHandshake(int aVersion, URI aURI, String aProtocol) throws WebSocketException {
        this.mURI = aURI;
        this.mProtocol = aProtocol;
        this.mVersion = aVersion;
        if (WebSocketProtocolAbstraction.isHybiVersion(aVersion)) {
            this.generateHybiKeys();
        } else if (WebSocketProtocolAbstraction.isHixieVersion(aVersion)) {
            this.generateHixieKeys();
        } else {
            throw new WebSocketException("WebSocket handshake: Illegal WebSocket protocol version '" + aVersion + "' detected.");
        }
    }

    public static String calcHybiSecKeyAccept(String aKey) {
        aKey = aKey + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        String lAccept = null;
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            byte[] lBufSource = aKey.getBytes("UTF-8");
            byte[] lBufTarget = md.digest(lBufSource);
            lAccept = Tools.base64Encode(lBufTarget);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lAccept;
    }

    private static long calcHixieSecKeyNum(String aKey) {
        StringBuilder lSB = new StringBuilder();
        int lSpaces = 0;
        for (int lIdx = 0; lIdx < aKey.length(); ++lIdx) {
            char lC = aKey.charAt(lIdx);
            if (lC == ' ') {
                ++lSpaces;
                continue;
            }
            if (lC < '0' || lC > '9') continue;
            lSB.append(lC);
        }
        long lRes = -1L;
        if (lSpaces > 0) {
            try {
                lRes = Long.parseLong(lSB.toString()) / (long)lSpaces;
            }
            catch (NumberFormatException lEx) {
                // empty catch block
            }
        }
        return lRes;
    }

    public static Map parseC2SRequest(byte[] aReq, boolean aIsSSL) {
        int lPos;
        String lSubProt = null;
        String lDraft = null;
        Integer lVersion = null;
        String lSecKey = null;
        String lSecKey1 = null;
        String lSecKey2 = null;
        byte[] lSecKey3 = new byte[8];
        String lSecKeyAccept = null;
        Long lSecNum1 = null;
        Long lSecNum2 = null;
        byte[] lSecKeyResp = new byte[8];
        String lUserAgent = null;
        Object lPragma = null;
        Object lAccept = null;
        Object lAcceptLanguage = null;
        Object lAcceptEncoding = null;
        Object lCacheControl = null;
        String lCookies = null;
        HashMap<String, Object> lRes = new HashMap<String, Object>();
        int lReqLen = aReq.length;
        String lRequest = "";
        try {
            lRequest = new String(aReq, "US-ASCII");
        }
        catch (Exception lEx) {
            // empty catch block
        }
        if (lRequest.indexOf("policy-file-request") >= 0) {
            lRes.put("policy-file-request", lRequest);
            return lRes;
        }
        Boolean lIsSecure = lRequest.indexOf("Sec-WebSocket") > 0;
        if (lRequest.indexOf("Sec-WebSocket-Key1:") >= 0 && lRequest.indexOf("Sec-WebSocket-Key2:") >= 0) {
            lReqLen -= 8;
            for (int lIdx = 0; lIdx < 8; ++lIdx) {
                lSecKey3[lIdx] = aReq[lReqLen + lIdx];
            }
        }
        if ((lPos = lRequest.indexOf("Host:")) < 0) {
            return null;
        }
        lPos += 6;
        String lHost = lRequest.substring(lPos);
        if ((lPos = lHost.indexOf("\r\n")) < 0) {
            return null;
        }
        lHost = lHost.substring(0, lPos);
        lPos = lRequest.indexOf("Origin:");
        if (lPos < 0) {
            return null;
        }
        lPos += 8;
        String lOrigin = lRequest.substring(lPos);
        if ((lPos = lOrigin.indexOf("\r\n")) < 0) {
            return null;
        }
        lOrigin = lOrigin.substring(0, lPos);
        lPos = lRequest.indexOf("GET");
        if (lPos < 0) {
            return null;
        }
        String lPath = lRequest.substring(lPos += 4);
        lPos = lPath.indexOf("HTTP");
        lPath = lPath.substring(0, lPos - 1);
        lPos = lRequest.indexOf("User-Agent:");
        if (lPos >= 0) {
            lUserAgent = lRequest.substring(lPos += 12);
            lPos = lUserAgent.indexOf("\r\n");
            lUserAgent = lUserAgent.substring(0, lPos);
        }
        String lLocation = (aIsSSL ? "wss" : "ws") + "://" + lHost + lPath;
        lPos = lRequest.indexOf("WebSocket-Protocol:");
        if (lPos > 0) {
            lSubProt = lRequest.substring(lPos += 20);
            lPos = lSubProt.indexOf("\r\n");
            lSubProt = lSubProt.substring(0, lPos);
        }
        if ((lPos = lRequest.indexOf("Sec-WebSocket-Draft:")) > 0) {
            lDraft = lRequest.substring(lPos += 21);
            lPos = lDraft.indexOf("\r\n");
            lDraft = lDraft.substring(0, lPos).trim();
        }
        if ((lPos = lRequest.indexOf("Sec-WebSocket-Version:")) > 0) {
            lDraft = lRequest.substring(lPos += 22);
            lPos = lDraft.indexOf("\r\n");
            lDraft = lDraft.substring(0, lPos).trim();
        }
        if ((lPos = lRequest.indexOf("Sec-WebSocket-Key1:")) > 0) {
            lSecKey1 = lRequest.substring(lPos += 20);
            lPos = lSecKey1.indexOf("\r\n");
            lSecKey1 = lSecKey1.substring(0, lPos);
            lSecNum1 = WebSocketHandshake.calcHixieSecKeyNum(lSecKey1);
        }
        if ((lPos = lRequest.indexOf("Sec-WebSocket-Key2:")) > 0) {
            lSecKey2 = lRequest.substring(lPos += 20);
            lPos = lSecKey2.indexOf("\r\n");
            lSecKey2 = lSecKey2.substring(0, lPos);
            lSecNum2 = WebSocketHandshake.calcHixieSecKeyNum(lSecKey2);
        }
        if ((lPos = lRequest.indexOf("Sec-WebSocket-Key:")) > 0) {
            lSecKey = lRequest.substring(lPos += 19);
            lPos = lSecKey.indexOf("\r\n");
            lSecKey = lSecKey.substring(0, lPos);
            lSecKeyAccept = WebSocketHandshake.calcHybiSecKeyAccept(lSecKey);
        }
        if (lSecNum1 != null && lSecNum2 != null) {
            BigInteger lSec1 = new BigInteger(lSecNum1.toString());
            BigInteger lSec2 = new BigInteger(lSecNum2.toString());
            byte[] l128Bit = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            byte[] lTmp = lSec1.toByteArray();
            int lIdx = lTmp.length;
            int lCnt = 0;
            while (lIdx > 0 && lCnt < 4) {
                l128Bit[4 - ++lCnt] = lTmp[--lIdx];
            }
            lTmp = lSec2.toByteArray();
            lIdx = lTmp.length;
            lCnt = 0;
            while (lIdx > 0 && lCnt < 4) {
                l128Bit[8 - ++lCnt] = lTmp[--lIdx];
            }
            lTmp = lSecKey3;
            System.arraycopy(lSecKey3, 0, l128Bit, 8, 8);
            try {
                MessageDigest lMD = MessageDigest.getInstance("MD5");
                lSecKeyResp = lMD.digest(l128Bit);
            }
            catch (Exception lEx) {
                // empty catch block
            }
        }
        if ((lPos = lRequest.indexOf("Cookie: ")) > 0) {
            lCookies = lRequest.substring(lPos += 8);
            lPos = lCookies.indexOf("\r\n");
            lCookies = lCookies.substring(0, lPos);
        }
        if (null != lCookies) {
            lRes.put("cookie", lCookies);
        }
        lRes.put("path", lPath);
        lRes.put("host", lHost);
        lRes.put("origin", lOrigin);
        lRes.put("location", lLocation);
        lRes.put("subprot", lSubProt);
        if (lSecKey != null) {
            lRes.put("secKey", lSecKey);
            lRes.put("secKeyAccept", lSecKeyAccept);
        }
        if (lSecKey1 != null && lSecKey2 != null) {
            lRes.put("secKey1", lSecKey1);
            lRes.put("secKey2", lSecKey2);
            lRes.put("secKeyResponse", lSecKeyResp);
        }
        if (lDraft != null) {
            try {
                lVersion = Integer.parseInt(lDraft, 10);
            }
            catch (Exception Ex) {
                // empty catch block
            }
        }
        if (lVersion == null) {
            if (lSecKey1 != null && lSecKey2 != null) {
                lVersion = 76;
                lDraft = "76";
            } else {
                lVersion = 75;
                lDraft = "75";
            }
        }
        if (lDraft != null) {
            lRes.put("draft", lDraft);
        }
        if (lVersion != null) {
            lRes.put("version", lVersion);
        }
        if (lUserAgent != null) {
            lRes.put("User-Agent", lUserAgent);
        }
        lRes.put("isSecure", lIsSecure);
        return lRes;
    }

    public static byte[] generateS2CResponse(Map aRequest) {
        byte[] lBA;
        String lPolicyFileRequest = (String)aRequest.get("policy-file-request");
        if (lPolicyFileRequest != null) {
            byte[] lBA2;
            try {
                lBA2 = "<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"*\" /></cross-domain-policy>\n".getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException lEx) {
                lBA2 = null;
            }
            return lBA2;
        }
        Boolean lIsSecure = (Boolean)aRequest.get("isSecure");
        String lSecKeyAccept = (String)aRequest.get("secKeyAccept");
        byte[] lSecKeyResponse = (byte[])aRequest.get("secKeyResponse");
        String lOrigin = (String)aRequest.get("origin");
        String lLocation = (String)aRequest.get("location");
        String lSubProt = (String)aRequest.get("subprot");
        String lRes = (lSecKeyAccept == null ? "HTTP/1.1 101 Web" + (lIsSecure != false ? "" : " ") + "Socket Protocol Handshake\r\n" + "Upgrade: WebSocket\r\n" + "Connection: Upgrade\r\n" : "HTTP/1.1 101 Switching Protocols\r\nUpgrade: websocket\r\nConnection: Upgrade\r\n") + (lSecKeyAccept != null ? "Sec-WebSocket-Accept: " + lSecKeyAccept + "\r\n" : "") + (lSubProt != null ? (lIsSecure != false ? "Sec-" : "") + "WebSocket-Protocol: " + lSubProt + "\r\n" : "") + (lIsSecure != false ? "Sec-" : "") + "WebSocket-Origin: " + lOrigin + "\r\n" + (lIsSecure != false ? "Sec-" : "") + "WebSocket-Location: " + lLocation + "\r\n" + "Set-Cookie: " + "JWSSESSIONID" + "=" + ((Map)aRequest.get("cookie")).get("JWSSESSIONID") + "; HttpOnly\r\n";
        lRes = lRes + "\r\n";
        try {
            lBA = lRes.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException lEx) {
            return null;
        }
        if (lSecKeyResponse != null) {
            byte[] lSecKey = lSecKeyResponse;
            byte[] lResult = new byte[lBA.length + lSecKey.length];
            System.arraycopy(lBA, 0, lResult, 0, lBA.length);
            System.arraycopy(lSecKey, 0, lResult, lBA.length, lSecKey.length);
            return lResult;
        }
        return lBA;
    }

    public static byte[] readS2CResponse(InputStream aIS) {
        int lIdx;
        byte[] lBuff = new byte[MAX_HEADER_SIZE];
        boolean lContinue = true;
        int lB1 = 0;
        int lB2 = 0;
        int lB3 = 0;
        int lB4 = 0;
        for (lIdx = 0; lContinue && lIdx < MAX_HEADER_SIZE; ++lIdx) {
            int lIn;
            try {
                lIn = aIS.read();
                if (lIn < 0) {
                    return null;
                }
            }
            catch (IOException lIOEx) {
                return null;
            }
            lB1 = lB2;
            lB2 = lB3;
            lB3 = lB4;
            lB4 = lIn;
            lContinue = lB1 != 13 || lB2 != 10 || lB3 != 13 || lB4 != 10;
            lBuff[lIdx] = (byte)lIn;
        }
        byte[] lRes = new byte[lIdx];
        System.arraycopy(lBuff, 0, lRes, 0, lIdx);
        return lRes;
    }

    public static Map parseS2CResponse(byte[] aResp) {
        HashMap lRes = new HashMap();
        String lResp = null;
        try {
            lResp = new String(aResp, "US-ASCII");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lRes;
    }

    public byte[] generateC2SRequest(List<HttpCookie> aCookies) {
        byte[] lHandshakeBytes;
        String lPath = this.mURI.getPath();
        String lHost = this.mURI.getHost();
        this.mOrigin = "http://" + lHost;
        if ("".equals(lPath)) {
            lPath = "/";
        }
        String lHandshake = "GET " + lPath + " HTTP/1.1\r\n" + "Host: " + lHost + "\r\n" + "Upgrade: WebSocket\r\n" + "Connection: Upgrade\r\n" + "Sec-WebSocket-Origin: " + this.mOrigin + "\r\n";
        if (this.mProtocol != null) {
            lHandshake = lHandshake + "Sec-WebSocket-Protocol: " + this.mProtocol + "\r\n";
        }
        if (null != aCookies && !aCookies.isEmpty()) {
            String lCookies = "";
            for (HttpCookie lCookie : aCookies) {
                if (!lCookies.equals("")) {
                    lCookies = lCookies + "; ";
                }
                lCookies = lCookies + lCookie.getName() + "=" + lCookie.getValue();
            }
            lHandshake = lHandshake + "Cookie: " + lCookies + "\r\n";
        }
        if (WebSocketProtocolAbstraction.isHixieVersion(this.mVersion)) {
            lHandshake = lHandshake + "Sec-WebSocket-Key1: " + this.mHixieKey1 + "\r\n" + "Sec-WebSocket-Key2: " + this.mHixieKey2 + "\r\n" + "\r\n";
            lHandshakeBytes = new byte[lHandshake.getBytes().length + 8];
            System.arraycopy(lHandshake.getBytes(), 0, lHandshakeBytes, 0, lHandshake.getBytes().length);
            System.arraycopy(this.mHixieKey3, 0, lHandshakeBytes, lHandshake.getBytes().length, 8);
        } else {
            lHandshake = lHandshake + "Sec-WebSocket-Key: " + this.mHybiKey + "\r\n";
            if (this.mVersion != null) {
                lHandshake = lHandshake + "Sec-WebSocket-Version: " + this.mVersion + "\r\n";
            }
            lHandshake = lHandshake + "\r\n";
            try {
                lHandshakeBytes = lHandshake.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException lEx) {
                lHandshakeBytes = lHandshake.getBytes();
            }
        }
        return lHandshakeBytes;
    }

    public byte[] generateC2SRequest() {
        return this.generateC2SRequest(null);
    }

    public void verifyServerResponse(Headers aHeaders) throws WebSocketException {
        if (WebSocketProtocolAbstraction.isHybiVersion(this.mVersion)) {
            String lWebSocketAccept = aHeaders.getField("Sec-WebSocket-Accept");
            if (null == this.mHybiKeyAccept || !this.mHybiKeyAccept.equals(lWebSocketAccept)) {
                throw new WebSocketException("WebSocket handshake: Illegal hybi server response detected.");
            }
        } else if (WebSocketProtocolAbstraction.isHixieVersion(this.mVersion)) {
            byte[] lWebSocketAccept = aHeaders.getTrailingBytes();
            if (null == this.mHixieKeyAccept || !Arrays.equals(this.mHixieKeyAccept, lWebSocketAccept)) {
                throw new WebSocketException("WebSocket handshake: Illegal hixie server response detected.");
            }
        } else {
            throw new WebSocketException("WebSocket handshake: Illegal WebSocket protocol version '" + this.mVersion + "' detected during response verification.");
        }
    }

    public void verifyServerStatusLine(String aStatusLine) throws WebSocketException {
        int lStatusCode = Integer.valueOf(aStatusLine.substring(9, 12));
        if (lStatusCode == 407) {
            throw new WebSocketException("Connection failed: proxy authentication not supported");
        }
        if (lStatusCode == 404) {
            throw new WebSocketException("Connection failed: 404 not found");
        }
        if (lStatusCode != 101) {
            throw new WebSocketException("Connection failed: unknown status code " + lStatusCode);
        }
    }

    public void verifyServerHandshakeHeaders(Map<String, String> aHeaders) throws WebSocketException {
        if (!aHeaders.get("Upgrade").equals("WebSocket")) {
            throw new WebSocketException("connection failed: missing header field in server handshake: Upgrade");
        }
        if (!aHeaders.get("Connection").equals("Upgrade")) {
            throw new WebSocketException("connection failed: missing header field in server handshake: Connection");
        }
        if (!aHeaders.get("Sec-WebSocket-Origin").equals(this.mOrigin)) {
            throw new WebSocketException("connection failed: missing header field in server handshake: Sec-WebSocket-Origin");
        }
        if (aHeaders.containsKey("Sec-WebSocket-Protocol") && this.mProtocol.indexOf(aHeaders.get("Sec-WebSocket-Protocol")) == -1) {
            throw new WebSocketException("connection failed: invalid header field in server handshake: Sec-WebSocket-Protocol, expected one of : " + this.mProtocol + ", but got: " + aHeaders.get("Sec-WebSocket-Protocol"));
        }
    }

    private void generateHybiKeys() {
        UUID lUUID = UUID.randomUUID();
        long lLeast = lUUID.getLeastSignificantBits();
        long lMost = lUUID.getMostSignificantBits();
        byte[] lBA = new byte[]{(byte)(lLeast & 0xFFL), (byte)((lLeast >>= 8) & 0xFFL), (byte)((lLeast >>= 8) & 0xFFL), (byte)((lLeast >>= 8) & 0xFFL), (byte)((lLeast >>= 8) & 0xFFL), (byte)((lLeast >>= 8) & 0xFFL), (byte)((lLeast >>= 8) & 0xFFL), (byte)((lLeast >>= 8) & 0xFFL), (byte)(lMost & 0xFFL), (byte)((lMost >>= 8) & 0xFFL), (byte)((lMost >>= 8) & 0xFFL), (byte)((lMost >>= 8) & 0xFFL), (byte)((lMost >>= 8) & 0xFFL), (byte)((lMost >>= 8) & 0xFFL), (byte)((lMost >>= 8) & 0xFFL), (byte)((lMost >>= 8) & 0xFFL)};
        this.mHybiKey = Tools.base64Encode(lBA);
        this.mHybiKeyAccept = WebSocketHandshake.calcHybiSecKeyAccept(this.mHybiKey);
    }

    private void generateHixieKeys() {
        int lSpaces1 = this.rand(1, 12);
        int lSpaces2 = this.rand(1, 12);
        int lMax1 = Integer.MAX_VALUE / lSpaces1;
        int lMax2 = Integer.MAX_VALUE / lSpaces2;
        int lNumber1 = this.rand(0, lMax1);
        int lNumber2 = this.rand(0, lMax2);
        int lProduct1 = lNumber1 * lSpaces1;
        int lProduct2 = lNumber2 * lSpaces2;
        this.mHixieKey1 = Integer.toString(lProduct1);
        this.mHixieKey2 = Integer.toString(lProduct2);
        this.mHixieKey1 = this.insertRandomCharacters(this.mHixieKey1);
        this.mHixieKey2 = this.insertRandomCharacters(this.mHixieKey2);
        this.mHixieKey1 = this.insertSpaces(this.mHixieKey1, lSpaces1);
        this.mHixieKey2 = this.insertSpaces(this.mHixieKey2, lSpaces2);
        this.mHixieKey3 = this.createRandomBytes();
        ByteBuffer lBuffer = ByteBuffer.allocate(4);
        lBuffer.putInt(lNumber1);
        byte[] lNumber1Array = lBuffer.array();
        lBuffer = ByteBuffer.allocate(4);
        lBuffer.putInt(lNumber2);
        byte[] lNumber2Array = lBuffer.array();
        byte[] lChallenge = new byte[16];
        System.arraycopy(lNumber1Array, 0, lChallenge, 0, 4);
        System.arraycopy(lNumber2Array, 0, lChallenge, 4, 4);
        System.arraycopy(this.mHixieKey3, 0, lChallenge, 8, 8);
        this.mHixieKeyAccept = this.md5(lChallenge);
    }

    private String insertRandomCharacters(String aKey) {
        int lCount = this.rand(1, 12);
        char[] lRandomChars = new char[lCount];
        int lRandCount = 0;
        while (lRandCount < lCount) {
            int lRand = (int)(Math.random() * 126.0 + 33.0);
            if ((33 >= lRand || lRand >= 47) && (58 >= lRand || lRand >= 126)) continue;
            lRandomChars[lRandCount] = (char)lRand;
            ++lRandCount;
        }
        for (int lIdx = 0; lIdx < lCount; ++lIdx) {
            int lSplit = this.rand(1, aKey.length() - 1);
            String lPart1 = aKey.substring(0, lSplit);
            String lPart2 = aKey.substring(lSplit);
            aKey = lPart1 + lRandomChars[lIdx] + lPart2;
        }
        return aKey;
    }

    private String insertSpaces(String aKey, int aSpaces) {
        for (int lIdx = 0; lIdx < aSpaces; ++lIdx) {
            int lSplit = this.rand(1, aKey.length() - 1);
            String lPart1 = aKey.substring(0, lSplit);
            String lPart2 = aKey.substring(lSplit);
            aKey = lPart1 + " " + lPart2;
        }
        return aKey;
    }

    private byte[] createRandomBytes() {
        byte[] lBytes = new byte[8];
        for (int lIdx = 0; lIdx < 8; ++lIdx) {
            lBytes[lIdx] = (byte)this.rand(0, 255);
        }
        return lBytes;
    }

    private byte[] md5(byte[] aBytes) {
        try {
            MessageDigest lMD = MessageDigest.getInstance("MD5");
            return lMD.digest(aBytes);
        }
        catch (NoSuchAlgorithmException lEx) {
            return null;
        }
    }

    private int rand(int aMin, int aMax) {
        int lRand = (int)(Math.random() * (double)aMax + (double)aMin);
        return lRand;
    }
}

