/*
 * Decompiled with CFR 0.152.
 */
package org.jwebsocket.kit;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.List;
import org.jwebsocket.api.WebSocketPacket;
import org.jwebsocket.config.JWebSocketCommonConstants;
import org.jwebsocket.kit.RawPacket;
import org.jwebsocket.kit.WebSocketEncoding;
import org.jwebsocket.kit.WebSocketFrameType;
import org.jwebsocket.kit.WebSocketOpcode;
import org.jwebsocket.kit.WebSocketRuntimeException;

public class WebSocketProtocolAbstraction {
    public static boolean isHixieVersion(int aVersion) {
        return JWebSocketCommonConstants.WS_SUPPORTED_HIXIE_VERSIONS.contains(aVersion);
    }

    public static boolean isHybiVersion(int aVersion) {
        return JWebSocketCommonConstants.WS_SUPPORTED_HYBI_VERSIONS.contains(aVersion);
    }

    public static boolean isValidVersion(int aVersion) {
        return WebSocketProtocolAbstraction.isHixieVersion(aVersion) || WebSocketProtocolAbstraction.isHybiVersion(aVersion);
    }

    public static boolean isHixieDraft(String aDraft) {
        return JWebSocketCommonConstants.WS_SUPPORTED_HIXIE_DRAFTS.contains(aDraft);
    }

    public static boolean isHybiDraft(String aDraft) {
        return JWebSocketCommonConstants.WS_SUPPORTED_HYBI_DRAFTS.contains(aDraft);
    }

    public static boolean isValidDraft(String aDraft) {
        return WebSocketProtocolAbstraction.isHixieDraft(aDraft) || WebSocketProtocolAbstraction.isHybiDraft(aDraft);
    }

    public static byte[] calcClosePayload(int aReasonCode, byte[] aReason) {
        int lNewLength = aReason.length + 2;
        byte[] lRes = new byte[lNewLength];
        System.arraycopy(aReason, 0, lRes, 2, aReason.length);
        lRes[0] = (byte)((aReasonCode &= 0xFFFF) >> 8);
        lRes[1] = (byte)(aReasonCode & 0xFF);
        return lRes;
    }

    public static byte[] calcCloseData(int aReasonCode, String aReasonString) {
        return WebSocketProtocolAbstraction.calcClosePayload(aReasonCode, aReasonString.getBytes());
    }

    public static byte[] rawToProtocolPacket(int aVersion, WebSocketPacket aDataPacket) {
        int lSize;
        byte[] lBuff = new byte[2];
        WebSocketFrameType lFrameType = aDataPacket.getFrameType();
        int lTargetType = WebSocketProtocolAbstraction.frameTypeToOpcode(aVersion, lFrameType);
        if (lTargetType == -1) {
            throw new WebSocketRuntimeException("Cannot construct a packet with unknown packet type: " + (Object)((Object)lFrameType));
        }
        boolean lMasked = false;
        boolean lIsFIN = aVersion >= 4;
        lBuff[0] = lIsFIN ? (byte)(lTargetType | 0x80) : (byte)lTargetType;
        int lPayloadLen = aDataPacket.getByteArray().length;
        if (lPayloadLen < 126) {
            lBuff[1] = (byte)lPayloadLen;
        } else if (lPayloadLen >= 126 && lPayloadLen < 65535) {
            lBuff[1] = 126;
            lSize = lBuff.length;
            lBuff = WebSocketProtocolAbstraction.copyOf(lBuff, lSize + 2);
            lBuff[lSize] = (byte)(lPayloadLen >>> 8 & 0xFF);
            lBuff[lSize + 1] = (byte)(lPayloadLen & 0xFF);
        } else if (lPayloadLen >= 65535) {
            lBuff[1] = 127;
            long lLen = lPayloadLen;
            int lSize2 = lBuff.length;
            lBuff = WebSocketProtocolAbstraction.copyOf(lBuff, lSize2 + 8);
            lBuff[lSize2] = (byte)(lLen >>> 56);
            lBuff[lSize2 + 1] = (byte)(lLen >>> 48);
            lBuff[lSize2 + 2] = (byte)(lLen >>> 40);
            lBuff[lSize2 + 3] = (byte)(lLen >>> 32);
            lBuff[lSize2 + 4] = (byte)(lLen >>> 24);
            lBuff[lSize2 + 5] = (byte)(lLen >>> 16);
            lBuff[lSize2 + 6] = (byte)(lLen >>> 8);
            lBuff[lSize2 + 7] = (byte)lLen;
        }
        lSize = lBuff.length;
        lBuff = WebSocketProtocolAbstraction.copyOf(lBuff, lSize + aDataPacket.getByteArray().length);
        System.arraycopy(aDataPacket.getByteArray(), 0, lBuff, lSize, aDataPacket.getByteArray().length);
        return lBuff;
    }

    public static int read(InputStream aIS) throws Exception {
        int lByte = aIS.read();
        if (lByte < 0) {
            throw new Exception("EOF");
        }
        return lByte;
    }

    public static WebSocketPacket protocolToRawPacket(int aVersion, InputStream aIS) throws Exception {
        int lFlags = aIS.read();
        if (lFlags == -1) {
            return null;
        }
        ByteArrayOutputStream aBuff = new ByteArrayOutputStream();
        boolean lFragmented = aVersion >= 4 ? (lFlags & 0x80) == 0 : (lFlags & 0x80) == 128;
        int[] lMask = new int[4];
        int lOpcode = lFlags & 0xF;
        WebSocketFrameType lFrameType = WebSocketProtocolAbstraction.opcodeToFrameType(aVersion, lOpcode);
        if (lFrameType != WebSocketFrameType.INVALID) {
            boolean lMasked;
            long lPayloadLen = WebSocketProtocolAbstraction.read(aIS);
            boolean bl = lMasked = (lPayloadLen & 0x80L) == 128L;
            if ((lPayloadLen &= 0x7FL) == 126L) {
                lPayloadLen = WebSocketProtocolAbstraction.read(aIS) & 0xFF;
                lPayloadLen = lPayloadLen << 8 | (long)(WebSocketProtocolAbstraction.read(aIS) & 0xFF);
            } else if (lPayloadLen == 127L) {
                lPayloadLen = WebSocketProtocolAbstraction.read(aIS) & 0xFF;
                lPayloadLen = lPayloadLen << 8 | (long)(WebSocketProtocolAbstraction.read(aIS) & 0xFF);
                lPayloadLen = lPayloadLen << 8 | (long)(WebSocketProtocolAbstraction.read(aIS) & 0xFF);
                lPayloadLen = lPayloadLen << 8 | (long)(WebSocketProtocolAbstraction.read(aIS) & 0xFF);
                lPayloadLen = lPayloadLen << 8 | (long)(WebSocketProtocolAbstraction.read(aIS) & 0xFF);
                lPayloadLen = lPayloadLen << 8 | (long)(WebSocketProtocolAbstraction.read(aIS) & 0xFF);
                lPayloadLen = lPayloadLen << 8 | (long)(WebSocketProtocolAbstraction.read(aIS) & 0xFF);
                lPayloadLen = lPayloadLen << 8 | (long)(WebSocketProtocolAbstraction.read(aIS) & 0xFF);
            }
            if (lMasked) {
                lMask[0] = WebSocketProtocolAbstraction.read(aIS) & 0xFF;
                lMask[1] = WebSocketProtocolAbstraction.read(aIS) & 0xFF;
                lMask[2] = WebSocketProtocolAbstraction.read(aIS) & 0xFF;
                lMask[3] = WebSocketProtocolAbstraction.read(aIS) & 0xFF;
            }
            if (lPayloadLen > 0L) {
                if (lMasked) {
                    int j = 0;
                    while (lPayloadLen-- > 0L) {
                        aBuff.write(WebSocketProtocolAbstraction.read(aIS) ^ lMask[j]);
                        ++j;
                        j &= 3;
                    }
                } else {
                    while (lPayloadLen-- > 0L) {
                        aBuff.write(WebSocketProtocolAbstraction.read(aIS));
                    }
                }
            }
        }
        RawPacket lRes = new RawPacket(lFrameType, aBuff.toByteArray());
        return lRes;
    }

    public static List<byte[]> toProtocolPacketFragmented(WebSocketPacket aSrc, int aFragmentSize) {
        throw new UnsupportedOperationException("Fragmentation is currently not supported");
    }

    public static WebSocketFrameType opcodeToFrameType(int aVersion, int aOpcode) {
        WebSocketOpcode lOpcode = new WebSocketOpcode(aVersion);
        if (aOpcode == lOpcode.OPCODE_FRAGMENT) {
            return WebSocketFrameType.FRAGMENT;
        }
        if (aOpcode == lOpcode.OPCODE_TEXT) {
            return WebSocketFrameType.TEXT;
        }
        if (aOpcode == lOpcode.OPCODE_BINARY) {
            return WebSocketFrameType.BINARY;
        }
        if (aOpcode == lOpcode.OPCODE_CLOSE) {
            return WebSocketFrameType.CLOSE;
        }
        if (aOpcode == lOpcode.OPCODE_PING) {
            return WebSocketFrameType.PING;
        }
        if (aOpcode == lOpcode.OPCODE_PONG) {
            return WebSocketFrameType.PONG;
        }
        return WebSocketFrameType.INVALID;
    }

    public static int frameTypeToOpcode(int aVersion, WebSocketFrameType aFrameType) {
        WebSocketOpcode lOpcode = new WebSocketOpcode(aVersion);
        switch (aFrameType) {
            case FRAGMENT: {
                return lOpcode.OPCODE_FRAGMENT;
            }
            case TEXT: {
                return lOpcode.OPCODE_TEXT;
            }
            case BINARY: {
                return lOpcode.OPCODE_BINARY;
            }
            case CLOSE: {
                return lOpcode.OPCODE_CLOSE;
            }
            case PING: {
                return lOpcode.OPCODE_PING;
            }
            case PONG: {
                return lOpcode.OPCODE_PONG;
            }
        }
        return lOpcode.OPCODE_INVALID;
    }

    public static WebSocketFrameType encodingToFrameType(WebSocketEncoding aEncoding) {
        switch (aEncoding) {
            case TEXT: {
                return WebSocketFrameType.TEXT;
            }
            case BINARY: {
                return WebSocketFrameType.BINARY;
            }
        }
        return WebSocketFrameType.INVALID;
    }

    private static byte[] copyOf(byte[] aOriginal, int aNewLength) {
        byte[] lCopy = new byte[aNewLength];
        System.arraycopy(aOriginal, 0, lCopy, 0, Math.min(aOriginal.length, aNewLength));
        return lCopy;
    }
}

