/*
 * Decompiled with CFR 0.152.
 */
package org.jwebsocket.packetProcessors;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Iterator;
import org.jwebsocket.api.WebSocketPacket;
import org.jwebsocket.kit.RawPacket;
import org.jwebsocket.token.Token;
import org.jwebsocket.token.TokenFactory;

public class CSVProcessor {
    public static Token packetToToken(WebSocketPacket aDataPacket) {
        Token lToken = TokenFactory.createToken();
        try {
            String aData = aDataPacket.getString("UTF-8");
            String[] lItems = aData.split(",");
            for (int i = 0; i < lItems.length; ++i) {
                String[] lKeyVal = lItems[i].split("=", 2);
                if (lKeyVal.length != 2) continue;
                String lVal = lKeyVal[1];
                if (lVal.length() <= 0) {
                    lToken.setValidated(lKeyVal[0], null);
                    continue;
                }
                if (lVal.startsWith("\"") && lVal.endsWith("\"")) {
                    lVal = lVal.replace("\\x2C", ",");
                    lVal = lVal.replace("\\x22", "\"");
                    lToken.setValidated(lKeyVal[0], lVal.substring(1, lVal.length() - 1));
                    continue;
                }
                lToken.setValidated(lKeyVal[0], lVal);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return lToken;
    }

    private static String stringToCSV(String aString) {
        aString = aString.replace(",", "\\x2C");
        aString = aString.replace("\"", "\\x22");
        return "\"" + aString + "\"";
    }

    private static String collectionToCSV(Collection<Object> aCollection) {
        String lRes = "";
        for (Object lItem : aCollection) {
            String llRes = CSVProcessor.objectToCSV(lItem);
            lRes = lRes + llRes + "|";
        }
        if (lRes.length() > 1) {
            lRes = lRes.substring(0, lRes.length() - 1);
        }
        lRes = "[" + lRes + "]";
        return lRes;
    }

    private static String objectToCSV(Object aObj) {
        String lRes = aObj == null ? "null" : (aObj instanceof String ? CSVProcessor.stringToCSV((String)aObj) : (aObj instanceof Collection ? CSVProcessor.collectionToCSV((Collection)aObj) : "\"" + aObj.toString() + "\""));
        return lRes;
    }

    public static WebSocketPacket tokenToPacket(Token aToken) {
        String lData = "";
        Iterator<String> lIterator = aToken.getKeyIterator();
        while (lIterator.hasNext()) {
            String lKey = lIterator.next();
            String lVal = aToken.getString(lKey);
            lData = lData + lKey + "=" + CSVProcessor.objectToCSV(lVal) + (lIterator.hasNext() ? "," : "");
        }
        RawPacket lPacket = null;
        try {
            lPacket = new RawPacket(lData, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        return lPacket;
    }
}

