/*
 * Decompiled with CFR 0.152.
 */
package org.jwebsocket.packetProcessors;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jwebsocket.api.ITokenizable;
import org.jwebsocket.api.WebSocketPacket;
import org.jwebsocket.kit.RawPacket;
import org.jwebsocket.token.MapToken;
import org.jwebsocket.token.Token;
import org.jwebsocket.token.TokenFactory;

public class JSONProcessor {
    public static Token jsonStringToToken(String aJsonString) {
        MapToken lToken = new MapToken();
        try {
            ObjectMapper lMapper = new ObjectMapper();
            Map lTree = lMapper.readValue(aJsonString, Map.class);
            lToken.setMap(lTree);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lToken;
    }

    public static Token packetToToken(WebSocketPacket aDataPacket) {
        Token lToken = null;
        try {
            lToken = JSONProcessor.jsonStringToToken(aDataPacket.getString("UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lToken;
    }

    public static WebSocketPacket tokenToPacket(Token aToken) {
        RawPacket lPacket = null;
        try {
            ObjectMapper lMapper = new ObjectMapper();
            String lData = lMapper.writeValueAsString(aToken.getMap());
            lPacket = new RawPacket(lData, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lPacket;
    }

    public static JSONArray listToJsonArray(List aList) throws JSONException {
        JSONArray lArray = new JSONArray();
        for (Object item : aList) {
            lArray.put(JSONProcessor.convertObjectToJson(item));
        }
        return lArray;
    }

    public static JSONArray objectListToJsonArray(Object[] aObjectList) throws JSONException {
        JSONArray lArray = new JSONArray();
        for (int lIdx = 0; lIdx < aObjectList.length; ++lIdx) {
            Object lObj = aObjectList[lIdx];
            lArray.put(JSONProcessor.convertObjectToJson(lObj));
        }
        return lArray;
    }

    public static JSONObject mapToJsonObject(Map<?, ?> aMap) throws JSONException {
        JSONObject lObject = new JSONObject();
        for (Map.Entry<?, ?> lEntry : aMap.entrySet()) {
            String lKey = lEntry.getKey().toString();
            Object lValue = JSONProcessor.convertObjectToJson(lEntry.getValue());
            lObject.put(lKey, lValue);
        }
        return lObject;
    }

    public static Object convertObjectToJson(Object aObject) throws JSONException {
        if (aObject instanceof List) {
            return JSONProcessor.listToJsonArray((List)aObject);
        }
        if (aObject instanceof ITokenizable) {
            Token lToken = TokenFactory.createToken();
            ((ITokenizable)aObject).writeToToken(lToken);
            return JSONProcessor.tokenToJSON(lToken);
        }
        if (aObject instanceof Token) {
            return JSONProcessor.tokenToJSON((Token)aObject);
        }
        if (aObject instanceof Object[]) {
            return JSONProcessor.objectListToJsonArray((Object[])aObject);
        }
        if (aObject instanceof Map) {
            return JSONProcessor.mapToJsonObject((Map)aObject);
        }
        return aObject;
    }

    public static JSONObject tokenToJSON(Token aToken) throws JSONException {
        JSONObject lJSO = new JSONObject();
        Iterator<String> iterator = aToken.getKeyIterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object value = aToken.getObject(key);
            lJSO.put(key, JSONProcessor.convertObjectToJson(value));
        }
        return lJSO;
    }
}

