/*
 * Decompiled with CFR 0.152.
 */
package org.jwebsocket.plugins.rpc;

import java.util.List;
import javolution.util.FastList;
import org.jwebsocket.token.Token;
import org.jwebsocket.token.TokenFactory;

public abstract class AbstractRpc {
    private static boolean defaultSpawnThread = false;
    private Boolean mSpawnThread = null;
    private String mClassname;
    private String mMethod;
    private List mArg = null;

    public static void setDefaultSpanwThread(boolean aDefaultValue) {
        defaultSpawnThread = aDefaultValue;
    }

    protected AbstractRpc() {
    }

    public AbstractRpc(String aClassname, String aMethod) {
        this(aClassname, aMethod, defaultSpawnThread);
    }

    public AbstractRpc(String aClassname, String aMethod, boolean aSpawnTread) {
        this.mClassname = aClassname;
        this.mMethod = aMethod;
        this.mSpawnThread = aSpawnTread;
    }

    public AbstractRpc(Token aToken) {
        this.mClassname = aToken.getString("classname");
        this.mMethod = aToken.getString("method");
        this.mSpawnThread = aToken.getBoolean("spawnThread", defaultSpawnThread);
        List lListOfArg = aToken.getList("args");
        if (lListOfArg != null) {
            this.mArg = lListOfArg;
        } else {
            Object lObject = aToken.getObject("args");
            if (lObject != null) {
                this.mArg = new FastList();
                this.mArg.add(lObject);
            }
        }
    }

    public AbstractRpc send(Object ... aArg) {
        if (aArg != null) {
            this.mArg = new FastList();
            for (int i = 0; i < aArg.length; ++i) {
                this.mArg.add(aArg[i]);
            }
        }
        return this;
    }

    public AbstractRpc sendListOfArgs(List aArgs) {
        this.mArg = aArgs;
        return this;
    }

    public Token call() {
        Token rpcToken = TokenFactory.createToken("rpc");
        rpcToken.setNS("org.jwebsocket.plugins.rpc");
        rpcToken.setString("classname", this.mClassname);
        rpcToken.setString("method", this.mMethod);
        rpcToken.setList("args", this.mArg);
        boolean lSpawnThread = this.mSpawnThread == null ? defaultSpawnThread : this.mSpawnThread;
        rpcToken.setBoolean("spawnThread", lSpawnThread);
        return rpcToken;
    }
}

