/*
 * Decompiled with CFR 0.152.
 */
package org.jwebsocket.plugins.rpc;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.jwebsocket.plugins.rpc.util.ListConverter;
import org.jwebsocket.plugins.rpc.util.MethodMatcherConversionException;
import org.jwebsocket.token.BaseTokenizable;
import org.jwebsocket.token.Token;
import org.jwebsocket.token.TokenFactory;

public class MethodMatcher {
    private Object[] mMethodParameters;
    private Method mMethod;

    public MethodMatcher(Method aMethod) {
        this.mMethod = aMethod;
    }

    public Object[] getMethodParameters() {
        return this.mMethodParameters;
    }

    public boolean isMethodMatchingAgainstParameter(List aArgs) {
        Class[] lParametersType = this.mMethod.getParameterTypes();
        if (aArgs == null) {
            if (lParametersType.length == 0) {
                this.mMethodParameters = null;
                return true;
            }
            return false;
        }
        this.mMethodParameters = new Object[lParametersType.length];
        if (this.getNumberOfValidParameters(lParametersType) == aArgs.size()) {
            try {
                int k = -1;
                for (int j = 0; j < lParametersType.length; ++j) {
                    Map lMap;
                    String lClassName;
                    Object lArg;
                    Class lParameterType = lParametersType[j];
                    if ((lArg = aArgs.get(++k)) instanceof Map && (lClassName = (String)(lMap = (Map)lArg).get("_jwsClassName")) != null) {
                        try {
                            Class<?> lClass = Class.forName(lClassName);
                            Class[] lCA = new Class[]{};
                            Constructor<?> lConstr = lClass.getConstructor(lCA);
                            lConstr.setAccessible(true);
                            Object lCustObj = lConstr.newInstance(new Object[0]);
                            if (lCustObj instanceof BaseTokenizable) {
                                Token lToken = TokenFactory.createToken();
                                lToken.setMap(lMap);
                                ((BaseTokenizable)lCustObj).readFromToken(lToken);
                            }
                            this.mMethodParameters[j] = lCustObj;
                        }
                        catch (Exception lEx) {
                            throw new MethodMatcherConversionException(lEx.getClass().getSimpleName() + ": " + lEx.getMessage());
                        }
                    }
                    if (this.mMethodParameters[j] != null) continue;
                    if (lParameterType == String.class) {
                        this.mMethodParameters[j] = (String)lArg;
                        continue;
                    }
                    if (lParameterType == Token.class) {
                        this.mMethodParameters[j] = (Token)lArg;
                        continue;
                    }
                    if (lParameterType == Integer.TYPE) {
                        this.mMethodParameters[j] = (Integer)lArg;
                        continue;
                    }
                    if (lParameterType == Boolean.TYPE) {
                        this.mMethodParameters[j] = (Boolean)lArg;
                        continue;
                    }
                    if (lParameterType == Double.TYPE) {
                        this.mMethodParameters[j] = (Double)lArg;
                        continue;
                    }
                    if (lParameterType == Integer.class) {
                        this.mMethodParameters[j] = (Integer)lArg;
                        continue;
                    }
                    if (lParameterType == Boolean.class) {
                        this.mMethodParameters[j] = (Boolean)lArg;
                        continue;
                    }
                    if (lParameterType == Double.class) {
                        this.mMethodParameters[j] = (Double)lArg;
                        continue;
                    }
                    if (lParameterType == List.class) {
                        Type genericParameterType = this.mMethod.getGenericParameterTypes()[j];
                        this.mMethodParameters[j] = ListConverter.convert((List)lArg, genericParameterType);
                        continue;
                    }
                    if (this.specificMatching(lParameterType, j)) {
                        --k;
                        continue;
                    }
                    throw new MethodMatcherConversionException("Can't extract an object with type '" + lParameterType.getName() + "' in a Token Object");
                }
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    protected int getNumberOfValidParameters(Class[] aListOfParametersType) {
        return aListOfParametersType.length;
    }

    protected void setMethodParameters(int aIndice, Object aParameter) {
        this.mMethodParameters[aIndice] = aParameter;
    }

    protected boolean specificMatching(Class lParameterType, int aIndice) {
        return false;
    }
}

