/*
 * Decompiled with CFR 0.152.
 */
package org.jwebsocket.token;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javolution.util.FastMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jwebsocket.api.ITokenizable;
import org.jwebsocket.token.BaseToken;
import org.jwebsocket.token.Token;

public class JSONToken
extends BaseToken
implements Token {
    private JSONObject mData = null;

    public JSONToken() {
        this.mData = new JSONObject();
    }

    public JSONToken(String aType) {
        this.mData = new JSONObject();
        this.setType(aType);
    }

    public JSONToken(JSONObject aJSON) {
        this.mData = aJSON;
    }

    public JSONToken(String aNS, String aType) {
        this.mData = new JSONObject();
        this.setNS(aNS);
        this.setType(aType);
    }

    @Override
    public void clear() {
    }

    @Override
    public void set(ITokenizable aTokenizable) {
    }

    @Override
    public Map getMap() {
        return null;
    }

    @Override
    public void setMap(Map aMap) {
    }

    public void setJSONObject(JSONObject aJSON) {
        this.mData = aJSON;
    }

    public JSONObject getJSONObject() {
        return this.mData;
    }

    private Object getValue(Object aValue) {
        if (aValue instanceof JSONToken) {
            aValue = ((JSONToken)aValue).getJSONObject();
        } else if (aValue instanceof Collection) {
            JSONArray lJA = new JSONArray();
            for (Object lItem : (Collection)aValue) {
                lJA.put(this.getValue(lItem));
            }
            aValue = lJA;
        } else if (aValue instanceof Map) {
            JSONObject lJO = new JSONObject();
            for (Map.Entry lItem : ((Map)aValue).entrySet()) {
                try {
                    lJO.put(lItem.getKey().toString(), this.getValue(lItem.getValue()));
                }
                catch (JSONException lEx) {}
            }
            aValue = lJO;
        } else if (aValue instanceof Object[]) {
            JSONArray lJA = new JSONArray();
            Object[] lOA = (Object[])aValue;
            for (int lIdx = 0; lIdx < lOA.length; ++lIdx) {
                lJA.put(this.getValue(lOA[lIdx]));
            }
            aValue = lJA;
        }
        return aValue;
    }

    public void put(String aKey, Object aValue) {
        try {
            this.mData.put(aKey, this.getValue(aValue));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public Object get(String aKey) {
        try {
            return this.mData.get(aKey);
        }
        catch (JSONException lEx) {
            return null;
        }
    }

    @Override
    public void remove(String aKey) {
        this.mData.remove(aKey);
    }

    @Override
    public String getString(String aKey, String aDefault) {
        String lResult;
        try {
            lResult = this.mData.getString(aKey);
        }
        catch (JSONException lEx) {
            lResult = aDefault;
        }
        return lResult;
    }

    @Override
    public void setString(String aKey, String aValue) {
        try {
            this.mData.put(aKey, aValue);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public String getString(String aKey) {
        return this.getString(aKey, null);
    }

    @Override
    public Integer getInteger(String aKey, Integer aDefault) {
        Integer lResult;
        try {
            lResult = this.mData.getInt(aKey);
        }
        catch (JSONException lEx) {
            lResult = aDefault;
        }
        return lResult;
    }

    @Override
    public Integer getInteger(String aKey) {
        return this.getInteger(aKey, null);
    }

    @Override
    public void setInteger(String aKey, Integer aValue) {
        try {
            this.mData.put(aKey, aValue);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public Long getLong(String aKey, Long aDefault) {
        Long lResult;
        try {
            lResult = this.mData.getLong(aKey);
        }
        catch (JSONException lEx) {
            lResult = aDefault;
        }
        return lResult;
    }

    @Override
    public Long getLong(String aKey) {
        return this.getLong(aKey, null);
    }

    @Override
    public void setLong(String aKey, Long aValue) {
        try {
            this.mData.put(aKey, aValue);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public Double getDouble(String aKey, Double aDefault) {
        Double lResult;
        try {
            lResult = this.mData.getDouble(aKey);
        }
        catch (JSONException lEx) {
            lResult = aDefault;
        }
        return lResult;
    }

    @Override
    public Double getDouble(String aKey) {
        return this.getDouble(aKey, null);
    }

    @Override
    public void setDouble(String aKey, Double aValue) {
        try {
            this.mData.put(aKey, aValue);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public Boolean getBoolean(String aKey, Boolean aDefault) {
        Boolean lResult;
        try {
            lResult = this.mData.getBoolean(aKey);
        }
        catch (JSONException lEx) {
            lResult = aDefault;
        }
        return lResult;
    }

    @Override
    public Boolean getBoolean(String aArg) {
        return this.getBoolean(aArg, null);
    }

    @Override
    public void setBoolean(String aKey, Boolean aValue) {
        try {
            this.mData.put(aKey, aValue);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public List getList(String aKey, List aDefault) {
        return null;
    }

    @Override
    public List getList(String aKey) {
        return null;
    }

    @Override
    public void setList(String aKey, List aList) {
        try {
            this.mData.put(aKey, aList);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public void setToken(String aKey, ITokenizable aTokenizable) {
    }

    @Override
    public void setToken(String aKey, Token aToken) {
    }

    @Override
    public Token getToken(String aKey) {
        return null;
    }

    @Override
    public Token getToken(String aKey, Token aDefault) {
        return null;
    }

    @Override
    public Map getMap(String aKey, Map aDefault) {
        return null;
    }

    @Override
    public Map getMap(String aKey) {
        FastMap<String, Object> lMap = new FastMap<String, Object>();
        Iterator lIterator = this.mData.keys();
        while (lIterator.hasNext()) {
            String lKey = (String)lIterator.next();
            try {
                Object lVal = this.mData.get(lKey);
                lMap.put(lKey, lVal);
            }
            catch (Exception lEx) {}
        }
        return lMap;
    }

    @Override
    public void setMap(String aKey, Map aMap) {
        try {
            this.mData.put(aKey, aMap);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public String toString() {
        return this.mData.toString();
    }

    @Override
    public Iterator<String> getKeyIterator() {
        return this.mData.keys();
    }

    @Override
    public Object getObject(String aKey) {
        Object lObj = null;
        try {
            lObj = this.mData.get(aKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lObj;
    }
}

