/*
 * Decompiled with CFR 0.152.
 */
package org.jwebsocket.token;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.jwebsocket.api.ITokenizable;
import org.jwebsocket.token.BaseToken;
import org.jwebsocket.token.Token;
import org.jwebsocket.token.TokenFactory;

public class MapToken
extends BaseToken
implements Token {
    private Map mData = null;

    public MapToken() {
        this.mData = new FastMap();
    }

    public MapToken(String aType) {
        this.mData = new FastMap();
        this.setType(aType);
    }

    public MapToken(FastMap aMap) {
        this.mData = aMap;
    }

    public MapToken(String aNS, String aType) {
        this.mData = new FastMap();
        this.setNS(aNS);
        this.setType(aType);
    }

    @Override
    public void clear() {
        this.mData.clear();
    }

    @Override
    public void set(ITokenizable aTokenizable) {
        aTokenizable.writeToToken(this);
    }

    @Override
    public void setMap(Map aMap) {
        this.mData = aMap;
    }

    @Override
    public Map getMap() {
        return this.mData;
    }

    private Object getValue(Object aValue) {
        if (aValue instanceof MapToken) {
            aValue = ((MapToken)((Object)aValue)).getMap();
        } else if (aValue instanceof Collection) {
            FastList<Object> lList = new FastList<Object>();
            for (Object lItem : (Collection)((Object)aValue)) {
                lList.add(this.getValue(lItem));
            }
            aValue = lList;
        } else if (aValue instanceof Map) {
            FastMap<String, Object> lMap = new FastMap<String, Object>();
            for (Map.Entry lItem : ((Map)((Object)aValue)).entrySet()) {
                lMap.put(lItem.getKey().toString(), this.getValue(lItem.getValue()));
            }
            aValue = lMap;
        } else if (aValue instanceof Object[]) {
            FastList<Object> lList = new FastList<Object>();
            Object[] lOA = (Object[])aValue;
            for (int lIdx = 0; lIdx < lOA.length; ++lIdx) {
                lList.add(this.getValue(lOA[lIdx]));
            }
            aValue = lList;
        }
        return aValue;
    }

    private void put(String aKey, Object aValue) {
        this.mData.put(aKey, this.getValue(aValue));
    }

    private Object get(String aKey) {
        return this.mData.get(aKey);
    }

    @Override
    public void remove(String aKey) {
        this.mData.remove(aKey);
    }

    @Override
    public String getString(String aKey, String aDefault) {
        String lResult;
        try {
            lResult = (String)this.mData.get(aKey);
            if (lResult == null) {
                lResult = aDefault;
            }
        }
        catch (Exception lEx) {
            lResult = aDefault;
        }
        return lResult;
    }

    @Override
    public void setString(String aKey, String aValue) {
        try {
            this.mData.put(aKey, aValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getString(String aKey) {
        return this.getString(aKey, null);
    }

    @Override
    public Integer getInteger(String aKey, Integer aDefault) {
        Integer lResult;
        try {
            lResult = (Integer)this.mData.get(aKey);
            if (lResult == null) {
                lResult = aDefault;
            }
        }
        catch (Exception lEx) {
            lResult = aDefault;
        }
        return lResult;
    }

    @Override
    public Integer getInteger(String aKey) {
        return this.getInteger(aKey, null);
    }

    @Override
    public void setInteger(String aKey, Integer aValue) {
        try {
            this.mData.put(aKey, aValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Long getLong(String aKey, Long aDefault) {
        Long lResult;
        try {
            lResult = (Long)this.mData.get(aKey);
            if (lResult == null) {
                lResult = aDefault;
            }
        }
        catch (Exception lEx) {
            lResult = aDefault;
        }
        return lResult;
    }

    @Override
    public Long getLong(String aKey) {
        return this.getLong(aKey, null);
    }

    @Override
    public void setLong(String aKey, Long aValue) {
        try {
            this.mData.put(aKey, aValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Double getDouble(String aKey, Double aDefault) {
        Double lResult;
        try {
            Object lObj = this.mData.get(aKey);
            lResult = lObj instanceof String ? Double.valueOf(Double.parseDouble((String)lObj)) : (lObj instanceof Integer ? Double.valueOf((double)((Integer)lObj).intValue() / 1.0) : (Double)lObj);
            if (lResult == null) {
                lResult = aDefault;
            }
        }
        catch (Exception lEx) {
            lResult = aDefault;
        }
        return lResult;
    }

    @Override
    public Double getDouble(String aKey) {
        return this.getDouble(aKey, null);
    }

    @Override
    public void setDouble(String aKey, Double aValue) {
        try {
            this.mData.put(aKey, aValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Boolean getBoolean(String aKey, Boolean aDefault) {
        Boolean lResult;
        try {
            lResult = (Boolean)this.mData.get(aKey);
            if (lResult == null) {
                lResult = aDefault;
            }
        }
        catch (Exception lEx) {
            lResult = aDefault;
        }
        return lResult;
    }

    @Override
    public Boolean getBoolean(String aArg) {
        return this.getBoolean(aArg, null);
    }

    @Override
    public void setBoolean(String aKey, Boolean aValue) {
        try {
            this.mData.put(aKey, aValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public List getList(String aKey) {
        return this.getList(aKey, null);
    }

    @Override
    public List getList(String aKey, List aDefault) {
        List lResult = null;
        try {
            lResult = (List)this.mData.get(aKey);
            if (lResult == null) {
                lResult = aDefault;
            }
        }
        catch (Exception lEx) {
            lResult = aDefault;
        }
        return lResult;
    }

    @Override
    public void setList(String aKey, List aList) {
        try {
            this.mData.put(aKey, aList);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setToken(String aKey, ITokenizable aTokenizable) {
        Token lToken = TokenFactory.createToken();
        aTokenizable.writeToToken(lToken);
        this.setToken(aKey, lToken);
    }

    @Override
    public void setToken(String aKey, Token aToken) {
        try {
            this.mData.put(aKey, aToken.getMap());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Token getToken(String aKey) {
        return this.getToken(aKey, null);
    }

    @Override
    public Token getToken(String aKey, Token aDefault) {
        Token lResult = null;
        try {
            lResult = (Token)this.mData.get(aKey);
            if (lResult == null) {
                lResult = aDefault;
            }
        }
        catch (Exception lEx) {
            lResult = aDefault;
        }
        return lResult;
    }

    @Override
    public Map getMap(String aKey, Map aDefault) {
        Map lResult = null;
        try {
            lResult = (Map)this.mData.get(aKey);
            if (lResult == null) {
                lResult = aDefault;
            }
        }
        catch (Exception lEx) {
            lResult = aDefault;
        }
        return lResult;
    }

    @Override
    public Map getMap(String aKey) {
        return this.getMap(aKey, null);
    }

    @Override
    public void setMap(String aKey, Map aMap) {
        try {
            this.mData.put(aKey, aMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return this.mData.toString();
    }

    @Override
    public Iterator<String> getKeyIterator() {
        return this.mData.keySet().iterator();
    }

    @Override
    public Object getObject(String aKey) {
        Object lObj = null;
        try {
            lObj = this.mData.get(aKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return lObj;
    }
}

