/*
 * Decompiled with CFR 0.152.
 */
package org.jwebsocket.token;

import org.jwebsocket.api.WebSocketPacket;
import org.jwebsocket.packetProcessors.CSVProcessor;
import org.jwebsocket.packetProcessors.JSONProcessor;
import org.jwebsocket.packetProcessors.XMLProcessor;
import org.jwebsocket.token.MapToken;
import org.jwebsocket.token.Token;

public class TokenFactory {
    public static Token createToken() {
        return new MapToken();
    }

    public static Token createToken(String aType) {
        return new MapToken(aType);
    }

    public static Token createToken(String aNS, String aType) {
        return new MapToken(aNS, aType);
    }

    public static Token packetToToken(String aFormat, WebSocketPacket aDataPacket) {
        Token lToken = null;
        if ("json".equals(aFormat)) {
            lToken = JSONProcessor.packetToToken(aDataPacket);
        } else if ("csv".equals(aFormat)) {
            lToken = CSVProcessor.packetToToken(aDataPacket);
        } else if ("xml".equals(aFormat)) {
            lToken = XMLProcessor.packetToToken(aDataPacket);
        }
        return lToken;
    }

    public static WebSocketPacket tokenToPacket(String aFormat, Token aToken) {
        WebSocketPacket lPacket = null;
        if ("json".equals(aFormat)) {
            lPacket = JSONProcessor.tokenToPacket(aToken);
        } else if ("csv".equals(aFormat)) {
            lPacket = CSVProcessor.tokenToPacket(aToken);
        } else if ("xml".equals(aFormat)) {
            lPacket = XMLProcessor.tokenToPacket(aToken);
        }
        return lPacket;
    }
}

