/*
 * Decompiled with CFR 0.152.
 */
package org.jwebsocket.util;

import java.lang.reflect.Method;
import java.net.HttpCookie;
import java.net.URI;
import java.security.MessageDigest;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javolution.util.FastList;
import javolution.util.FastMap;

public class Tools {
    private static final Map<String, String> JAVA_2_GENERIC_MAP;
    private static final Map<String, String> GENERIC_2_JAVA_MAP;
    private static Timer mTimer;
    public static final boolean EXPAND_CASE_SENSITIVE = false;
    public static final boolean EXPAND_CASE_INSENSITIVE = true;
    private static char[] BASE64_CHAR_MAP;
    static final String HEXES = "0123456789ABCDEF";

    public static String getMD5(String aMsg) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] lBufSource = aMsg.getBytes("UTF-8");
            byte[] lBufTarget = md.digest(lBufSource);
            Formatter formatter = new Formatter();
            for (byte b : lBufTarget) {
                formatter.format("%02x", b);
            }
            return formatter.toString();
        }
        catch (Exception ex) {
            System.out.println("getMD5: " + ex.getMessage());
            return null;
        }
    }

    public static String getSHA1(String aMsg) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] lBufSource = aMsg.getBytes("UTF-8");
            byte[] lBufTarget = md.digest(lBufSource);
            Formatter formatter = new Formatter();
            for (byte b : lBufTarget) {
                formatter.format("%02x", b);
            }
            return formatter.toString();
        }
        catch (Exception ex) {
            System.out.println("getSHA: " + ex.getMessage());
            return null;
        }
    }

    public static String intToHex(int aInt, int aLen) {
        String lRes = Integer.toHexString(aInt);
        if (aLen > 0 && lRes.length() > aLen) {
            lRes = lRes.substring(0, aLen);
        } else {
            while (lRes.length() < aLen) {
                lRes = "0" + lRes.substring(0, aLen);
            }
        }
        return lRes;
    }

    public static String intToString(int aInt, int aLen) {
        String lRes = Integer.toString(aInt);
        if (aLen > 0 && lRes.length() > aLen) {
            lRes = lRes.substring(0, aLen);
        } else {
            while (lRes.length() < aLen) {
                lRes = "0" + lRes;
            }
        }
        return lRes;
    }

    public static int stringToInt(String aString, int aDefault) {
        int lRes;
        try {
            lRes = Integer.parseInt(aString);
        }
        catch (Exception lEx) {
            lRes = aDefault;
        }
        return lRes;
    }

    public static long stringToLong(String aString, long aDefault) {
        long lRes;
        try {
            lRes = Long.parseLong(aString);
        }
        catch (Exception lEx) {
            lRes = aDefault;
        }
        return lRes;
    }

    public static Date ISO8601ToDate(String aISO8601Date) {
        SimpleDateFormat lSDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        try {
            return lSDF.parse(aISO8601Date);
        }
        catch (Exception lEx) {
            return null;
        }
    }

    public static String DateToISO8601(Date aDate) {
        SimpleDateFormat lSDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        return lSDF.format(aDate);
    }

    public static String DateToISO8601WithMillis(Date aDate) {
        SimpleDateFormat lSDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        return lSDF.format(aDate);
    }

    public static String getJavaClassnameFromGenericType(String aGenericType) {
        return GENERIC_2_JAVA_MAP.get(aGenericType);
    }

    public static Object castGenericToJava(Object aValue, String aFromType, String aToType) {
        if (aValue == null) {
            return null;
        }
        if (aFromType != null && aValue != null) {
            aFromType = aFromType.toLowerCase();
            if (aToType != null) {
                aToType = aToType.toLowerCase();
            }
            if ("datetime".equals(aFromType)) {
                Date lDate;
                if (aValue instanceof String && (lDate = Tools.ISO8601ToDate((String)aValue)) != null) {
                    if ("timestamp".equals(aToType)) {
                        return new Timestamp(lDate.getTime());
                    }
                    return lDate;
                }
            } else if ("string".equals(aFromType)) {
                if (aValue instanceof String) {
                    return (String)aValue;
                }
            } else if ("integer".equals(aFromType)) {
                if (aValue instanceof Integer) {
                    return (Integer)aValue;
                }
            } else if ("float".equals(aFromType)) {
                if (aValue instanceof Float) {
                    return (Float)aValue;
                }
            } else if ("double".equals(aFromType)) {
                if (aValue instanceof Double) {
                    return (Double)aValue;
                }
            } else if ("boolean".equals(aFromType) && aValue instanceof Boolean) {
                return (Boolean)aValue;
            }
        }
        return null;
    }

    public static String getGenericTypeStringFromJavaClassname(String aClassname) {
        return JAVA_2_GENERIC_MAP.get(aClassname);
    }

    public static String expandVars(String aString, Map<String, String> aVars, boolean aIgnoreCase) {
        String lPattern = "\\$\\{([A-Za-z0-9_]+)\\}";
        int lFlags = aIgnoreCase ? 2 : 0;
        Pattern lRegExpr = Pattern.compile(lPattern, lFlags);
        Matcher lMatcher = lRegExpr.matcher(aString);
        while (lMatcher.find()) {
            String lFoundVal = lMatcher.group(1);
            String lEnvVal = aVars.get(lFoundVal);
            lEnvVal = lEnvVal == null ? "" : lEnvVal.replace("\\", "\\\\");
            Pattern lSubExpr = Pattern.compile(Pattern.quote(lMatcher.group(0)));
            aString = lSubExpr.matcher(aString).replaceAll(lEnvVal);
        }
        return aString;
    }

    public static String expandEnvVars(String aString) {
        Map<String, String> lVarsMap = System.getenv();
        return Tools.expandVars(aString, lVarsMap, true);
    }

    public static String expandProps(String aString) {
        FastMap<String, String> lVarsMap = new FastMap<String, String>();
        Properties lProps = System.getProperties();
        for (Map.Entry<Object, Object> lEntry : lProps.entrySet()) {
            Object lKey = lEntry.getKey();
            Object lValue = lEntry.getValue();
            if (!(lKey instanceof String) || !(lValue instanceof String)) continue;
            lVarsMap.put((String)lKey, (String)lValue);
        }
        return Tools.expandVars(aString, lVarsMap, true);
    }

    public static String expandEnvVarsAndProps(String aString) {
        FastMap<String, String> lVarsMap = new FastMap<String, String>(System.getenv());
        Properties lProps = System.getProperties();
        for (Map.Entry<Object, Object> lEntry : lProps.entrySet()) {
            Object lKey = lEntry.getKey();
            Object lValue = lEntry.getValue();
            if (null == lKey || null == lValue || !(lKey instanceof String) || !(lValue instanceof String)) continue;
            lVarsMap.put((String)lKey, (String)lValue);
        }
        return Tools.expandVars(aString, lVarsMap, true);
    }

    public static Object invoke(String aClassName, String aMethodName, Object ... aArgs) throws Exception {
        Class<?> lClass = Class.forName(aClassName);
        Class[] lArgClasses = null;
        if (aArgs != null) {
            lArgClasses = new Class[aArgs.length];
            for (int lIdx = 0; lIdx < lArgClasses.length; ++lIdx) {
                lArgClasses[lIdx] = aArgs[lIdx].getClass();
            }
        }
        Method lMthd = lClass.getMethod(aMethodName, lArgClasses);
        Object lRes = lMthd.invoke(null, aArgs);
        return lRes;
    }

    public static Object invoke(Class aClass, String aMethodName, Object ... aArgs) throws Exception {
        Method lMthd;
        if (aClass == null) {
            throw new Exception("No class passed for call.");
        }
        Class[] lArgClasses = null;
        if (aArgs != null) {
            lArgClasses = new Class[aArgs.length];
            for (int lIdx = 0; lIdx < lArgClasses.length; ++lIdx) {
                Class<?> lClass;
                lArgClasses[lIdx] = lClass = aArgs[lIdx].getClass();
            }
        }
        if ((lMthd = aClass.getMethod(aMethodName, lArgClasses)) == null) {
            throw new Exception("Method '" + aMethodName + "' not found.");
        }
        Object lRes = lMthd.invoke(null, aArgs);
        return lRes;
    }

    public static Object invokeUnique(Class aClass, String aMethodName, Object ... aArgs) throws Exception {
        if (aClass == null) {
            throw new Exception("No class passed for call.");
        }
        if (aMethodName == null) {
            throw new Exception("No method name passed for call.");
        }
        if (aArgs != null) {
            Class[] lArgClasses = new Class[aArgs.length];
            for (int lIdx = 0; lIdx < lArgClasses.length; ++lIdx) {
                Class<?> lClass;
                lArgClasses[lIdx] = lClass = aArgs[lIdx].getClass();
            }
        }
        Method lMthd = null;
        Method[] lMethods = aClass.getMethods();
        for (int lIdx = 0; lIdx < lMethods.length; ++lIdx) {
            if (!aMethodName.equals(lMethods[lIdx].getName())) continue;
            lMthd = lMethods[lIdx];
            break;
        }
        if (lMthd == null) {
            throw new Exception("Method '" + aMethodName + "' not found.");
        }
        Object lRes = lMthd.invoke(null, aArgs);
        return lRes;
    }

    public static Object invokeUnique(Class aClass, String aMethodName, Object[] aArgs, Class[] aClasses) throws Exception {
        if (aClass == null) {
            throw new Exception("No class passed for call.");
        }
        if (aArgs != null && aClasses != null && aArgs.length != aClasses.length) {
            throw new Exception("Number of aclasses must match the number of arguments.");
        }
        if (aMethodName == null) {
            throw new Exception("No method name passed for call.");
        }
        if (aArgs != null) {
            Class[] lArgClasses = new Class[aArgs.length];
            for (int lIdx = 0; lIdx < lArgClasses.length; ++lIdx) {
                Class<?> lClass;
                lArgClasses[lIdx] = lClass = aClasses[lIdx].getClass();
            }
        }
        Method lMthd = null;
        Method[] lMethods = aClass.getMethods();
        for (int lIdx = 0; lIdx < lMethods.length; ++lIdx) {
            if (!aMethodName.equals(lMethods[lIdx].getName())) continue;
            lMthd = lMethods[lIdx];
            break;
        }
        if (lMthd == null) {
            throw new Exception("Method '" + aMethodName + "' not found.");
        }
        Object lRes = lMthd.invoke(null, aArgs);
        return lRes;
    }

    public static Object invoke(Object aInstance, String aMethodName, Object ... aArgs) throws Exception {
        if (aInstance == null) {
            throw new Exception("No instance passed for call.");
        }
        Class<?> lClass = aInstance.getClass();
        Class[] lArgClasses = null;
        if (aArgs != null) {
            lArgClasses = new Class[aArgs.length];
            for (int lIdx = 0; lIdx < lArgClasses.length; ++lIdx) {
                lArgClasses[lIdx] = aArgs[lIdx].getClass();
            }
        }
        Method lMthd = lClass.getMethod(aMethodName, lArgClasses);
        if (aArgs == null) {
            aArgs = new Object[]{};
        }
        Object lRes = lMthd.invoke(aInstance, aArgs);
        return lRes;
    }

    public static String base64Encode(byte[] aBA) {
        int lLen = aBA.length;
        int oDataLen = (lLen * 4 + 2) / 3;
        int oLen = (lLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ip = 0;
        int op = 0;
        while (ip < lLen) {
            int i0 = aBA[ip++] & 0xFF;
            int i1 = ip < lLen ? aBA[ip++] & 0xFF : 0;
            int i2 = ip < lLen ? aBA[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = BASE64_CHAR_MAP[o0];
            out[op++] = BASE64_CHAR_MAP[o1];
            out[op] = op < oDataLen ? BASE64_CHAR_MAP[o2] : 61;
            int n = ++op < oDataLen ? BASE64_CHAR_MAP[o3] : 61;
            out[op] = n;
            ++op;
        }
        return new String(out);
    }

    public static List<String> parseStringArrayToList(String[] aArray) {
        FastList<String> lRes = new FastList<String>();
        int lEnd = aArray.length;
        for (int lIdx = 0; lIdx < lEnd; ++lIdx) {
            lRes.add(aArray[lIdx]);
        }
        return lRes;
    }

    public static void startUtilityTimer() {
        if (null == mTimer) {
            mTimer = new Timer("jWebSocket Utility Timer");
        }
    }

    public static void stopUtilityTimer() {
        if (null != mTimer) {
            mTimer.cancel();
            mTimer.purge();
        }
    }

    public static Timer getTimer() {
        if (null == mTimer) {
            Tools.startUtilityTimer();
        }
        return mTimer;
    }

    public static byte[] hexStringToByteArray(String aString) {
        int lLength = aString.length();
        byte[] lData = new byte[lLength / 2];
        for (int lIndex = 0; lIndex < lLength; lIndex += 2) {
            lData[lIndex / 2] = (byte)((Character.digit(aString.charAt(lIndex), 16) << 4) + Character.digit(aString.charAt(lIndex + 1), 16));
        }
        return lData;
    }

    public static String hexByteArrayToString(byte[] aByteArray) {
        if (aByteArray == null) {
            return null;
        }
        StringBuilder lHexBuilder = new StringBuilder(2 * aByteArray.length);
        for (byte lByte : aByteArray) {
            lHexBuilder.append(HEXES.charAt((lByte & 0xF0) >> 4)).append(HEXES.charAt(lByte & 0xF));
        }
        return lHexBuilder.toString();
    }

    public static boolean isCookieValid(URI aURI, HttpCookie aCookie) {
        return !aCookie.hasExpired() && (null == aCookie.getDomain() || HttpCookie.domainMatches(aCookie.getDomain(), aURI.getHost())) && (null == aCookie.getPath() || null != aURI.getPath() && aURI.getPath().startsWith(aCookie.getPath())) && aCookie.getSecure() == aURI.getScheme().equals("wss");
    }

    public static String appendTrailingSeparator(String aPath) {
        if (null != aPath && !aPath.endsWith("\\") && !aPath.endsWith("/")) {
            aPath = aPath + System.getProperty("file.separator");
        }
        return aPath;
    }

    static {
        int lC;
        JAVA_2_GENERIC_MAP = new FastMap<String, String>();
        GENERIC_2_JAVA_MAP = new FastMap<String, String>();
        mTimer = null;
        JAVA_2_GENERIC_MAP.put("java.lang.String", "string");
        JAVA_2_GENERIC_MAP.put("java.lang.Boolean", "boolean");
        JAVA_2_GENERIC_MAP.put("java.lang.Byte", "integer");
        JAVA_2_GENERIC_MAP.put("java.lang.Short", "integer");
        JAVA_2_GENERIC_MAP.put("java.lang.Integer", "integer");
        JAVA_2_GENERIC_MAP.put("java.lang.Long", "long");
        JAVA_2_GENERIC_MAP.put("java.lang.Float", "float");
        JAVA_2_GENERIC_MAP.put("java.lang.Double", "double");
        JAVA_2_GENERIC_MAP.put("java.math.BigDecimal", "double");
        JAVA_2_GENERIC_MAP.put("java.sql.Timestamp", "datetime");
        JAVA_2_GENERIC_MAP.put("java.sql.Date", "date");
        JAVA_2_GENERIC_MAP.put("java.sql.Time", "time");
        JAVA_2_GENERIC_MAP.put("java.util.Date", "datetime");
        JAVA_2_GENERIC_MAP.put("java.util.Collection", "list");
        JAVA_2_GENERIC_MAP.put("java.util.List", "list");
        JAVA_2_GENERIC_MAP.put("java.util.Set", "list");
        JAVA_2_GENERIC_MAP.put("java.util.Map", "map");
        GENERIC_2_JAVA_MAP.put("string", "java.lang.String");
        GENERIC_2_JAVA_MAP.put("boolean", "java.lang.Boolean");
        GENERIC_2_JAVA_MAP.put("integer", "java.lang.Integer");
        GENERIC_2_JAVA_MAP.put("long", "java.lang.Long");
        GENERIC_2_JAVA_MAP.put("float", "java.lang.Float");
        GENERIC_2_JAVA_MAP.put("double", "java.lang.Double");
        GENERIC_2_JAVA_MAP.put("list", "java.util.List");
        GENERIC_2_JAVA_MAP.put("map", "java.util.Map");
        GENERIC_2_JAVA_MAP.put("time", "java.util.Date");
        GENERIC_2_JAVA_MAP.put("date", "java.util.Date");
        GENERIC_2_JAVA_MAP.put("datetime", "java.util.Date");
        BASE64_CHAR_MAP = new char[64];
        int lIdx = 0;
        for (lC = 65; lC <= 90; lC = (int)((char)(lC + 1))) {
            Tools.BASE64_CHAR_MAP[lIdx++] = lC;
        }
        for (lC = 97; lC <= 122; lC = (int)((char)(lC + 1))) {
            Tools.BASE64_CHAR_MAP[lIdx++] = lC;
        }
        for (lC = 48; lC <= 57; lC = (int)((char)(lC + 1))) {
            Tools.BASE64_CHAR_MAP[lIdx++] = lC;
        }
        Tools.BASE64_CHAR_MAP[lIdx++] = 43;
        Tools.BASE64_CHAR_MAP[lIdx++] = 47;
    }
}

