/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.example;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import to.sparks.mtgox.MtGoxHTTPClient;
import to.sparks.mtgox.model.AccountInfo;
import to.sparks.mtgox.model.Lag;
import to.sparks.mtgox.model.Order;
import to.sparks.mtgox.model.Ticker;

public class HowToGetInfo {
    static final Logger logger = Logger.getLogger(HowToGetInfo.class.getName());

    public static void main(String[] args) throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("to/sparks/mtgox/example/Beans.xml");
        MtGoxHTTPClient mtgoxUSD = (MtGoxHTTPClient)context.getBean("mtgoxUSD");
        Lag lag = mtgoxUSD.getLag();
        logger.log(Level.INFO, "Current lag: {0}", lag.getLag());
        Ticker ticker = mtgoxUSD.getTicker();
        logger.log(Level.INFO, "Last price: {0}", ticker.getLast().toPlainString());
        AccountInfo info = mtgoxUSD.getAccountInfo();
        logger.log(Level.INFO, "Logged into account: {0}", info.getLogin());
        Object[] openOrders = mtgoxUSD.getOpenOrders();
        if (ArrayUtils.isNotEmpty(openOrders)) {
            for (Object order : openOrders) {
                logger.log(Level.INFO, "Open order: {0} status: {1} price: {2}{3} amount: {4}", new Object[]{((Order)order).getOid(), ((Order)order).getStatus(), ((Order)order).getCurrency().getCurrencyCode(), ((Order)order).getPrice().getDisplay(), ((Order)order).getAmount().getDisplay()});
            }
        } else {
            logger.info("There are no currently open bid or ask orders.");
        }
    }
}

