/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.example;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import to.sparks.mtgox.MtGoxHTTPClient;
import to.sparks.mtgox.event.StreamEvent;
import to.sparks.mtgox.event.TickerEvent;
import to.sparks.mtgox.event.TradeEvent;
import to.sparks.mtgox.model.AccountInfo;
import to.sparks.mtgox.model.CurrencyInfo;
import to.sparks.mtgox.model.MtGoxBitcoin;
import to.sparks.mtgox.model.MtGoxFiatCurrency;
import to.sparks.mtgox.model.Order;
import to.sparks.mtgox.model.Ticker;
import to.sparks.mtgox.model.Trade;
import to.sparks.mtgox.model.Wallet;

public class TradingBot
implements ApplicationListener<StreamEvent> {
    static final Logger logger = Logger.getLogger(TradingBot.class.getName());
    static final double[] percentagesOrderPriceSpread = new double[]{0.08, 0.16, 0.45, 0.14, 0.05};
    static final double[] percentagesAboveOrBelowPrice = new double[]{0.003, 0.005, 0.008, 0.012, 0.016};
    static final BigDecimal percentAllowedPriceDeviation = BigDecimal.valueOf(0.0015);
    private SimpleAsyncTaskExecutor taskExecutor;
    private MtGoxHTTPClient mtgoxAPI;
    private CurrencyInfo baseCurrency;
    private Ticker lastTicker;
    private Date timeOfLastOrder = Calendar.getInstance().getTime();

    public TradingBot(SimpleAsyncTaskExecutor taskExecutor, MtGoxHTTPClient mtgoxAPI) throws Exception {
        this.mtgoxAPI = mtgoxAPI;
        this.taskExecutor = taskExecutor;
        AccountInfo info = mtgoxAPI.getAccountInfo();
        logger.log(Level.INFO, "Logged into account: {0}", info.getLogin());
        this.baseCurrency = mtgoxAPI.getCurrencyInfo(mtgoxAPI.getBaseCurrency());
        String currencyCode = this.baseCurrency.getCurrency().getCurrencyCode();
        logger.log(Level.INFO, "Configured base currency: {0}", currencyCode);
        this.lastTicker = mtgoxAPI.getTicker();
        taskExecutor.execute(new Logic());
        logger.info("Waiting for trade events to trigger bot activity...");
    }

    public static void main(String[] args) throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("to/sparks/mtgox/example/TradingBot.xml");
        TradingBot me = context.getBean("tradingBot", TradingBot.class);
    }

    @Override
    public void onApplicationEvent(StreamEvent event) {
        try {
            if (event instanceof TradeEvent) {
                Trade trade = (Trade)event.getPayload();
                if (trade.getPrice().getCurrencyInfo().equals(this.baseCurrency)) {
                    if (trade.getAmount().compareTo(new MtGoxBitcoin(0.9)) > 0) {
                        logger.log(Level.INFO, "Market-making trade event: {0}${1} volume: {2}", new Object[]{trade.getPrice_currency(), trade.getPrice().toPlainString(), trade.getAmount().toPlainString()});
                        Calendar thirtySecondsAgo = Calendar.getInstance();
                        thirtySecondsAgo.add(13, -30);
                        if (this.timeOfLastOrder.before(thirtySecondsAgo.getTime())) {
                            this.taskExecutor.execute(new Logic());
                            this.timeOfLastOrder = Calendar.getInstance().getTime();
                        } else {
                            logger.info("Ignoring order because too soon.");
                        }
                    } else {
                        logger.log(Level.FINE, "Insufficient sized trade event: {0}${1} volume: {2}", new Object[]{trade.getPrice_currency(), trade.getPrice().toPlainString(), trade.getAmount().toPlainString()});
                    }
                }
            } else if (event instanceof TickerEvent && ((Ticker)event.getPayload()).getCurrencyCode().equalsIgnoreCase(this.baseCurrency.getCurrency().getCurrencyCode())) {
                this.lastTicker = (Ticker)event.getPayload();
                logger.log(Level.FINE, "Ticker Last: {0}{1}{2} Volume: {3} Buy: {0}{4} Sell: {0}{5}", new Object[]{this.lastTicker.getVwap().getCurrencyInfo().getCurrency().getCurrencyCode(), this.lastTicker.getVwap().getCurrencyInfo().getSymbol(), this.lastTicker.getLast().toPlainString(), this.lastTicker.getVol().toPlainString(), this.lastTicker.getBuy().getDisplay(), this.lastTicker.getSell().getDisplay()});
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private static boolean isOrdersValid(MtGoxFiatCurrency[] optimumBidPrices, MtGoxFiatCurrency[] optimumAskPrices, Order[] orders) {
        boolean bRet = false;
        if (ArrayUtils.isNotEmpty(orders) && orders.length == percentagesOrderPriceSpread.length * 2 && orders.length == percentagesAboveOrBelowPrice.length * 2) {
            return TradingBot.isWithinAllowedDeviation(percentAllowedPriceDeviation, orders, optimumBidPrices, optimumAskPrices);
        }
        return bRet;
    }

    private static MtGoxFiatCurrency getPriceAtOrderIndex(MtGoxHTTPClient.OrderType orderType, MtGoxFiatCurrency lastPrice, int index) {
        MtGoxFiatCurrency price = orderType == MtGoxHTTPClient.OrderType.Bid ? new MtGoxFiatCurrency(lastPrice.subtract(lastPrice.multiply(BigDecimal.valueOf(percentagesAboveOrBelowPrice[index]))), lastPrice.getCurrencyInfo()) : new MtGoxFiatCurrency(lastPrice.add(lastPrice.multiply(BigDecimal.valueOf(percentagesAboveOrBelowPrice[index]))), lastPrice.getCurrencyInfo());
        return price;
    }

    private static boolean isWithinAllowedDeviation(BigDecimal percentAllowedPriceDeviation, Order[] allOrders, MtGoxFiatCurrency[] optimumBidPrices, MtGoxFiatCurrency[] optimumAskPrices) {
        int i;
        boolean bRet = true;
        ArrayList<Order> bidOrders = new ArrayList<Order>();
        ArrayList<Order> askOrders = new ArrayList<Order>();
        for (Order order : allOrders) {
            if (order.getType() == MtGoxHTTPClient.OrderType.Bid) {
                bidOrders.add(order);
                continue;
            }
            askOrders.add(order);
        }
        Collections.sort(bidOrders, new ReverseComparator(new Comparator<Order>(){

            @Override
            public int compare(Order o1, Order o2) {
                return o1.getPrice().getPriceValue().compareTo(o2.getPrice().getPriceValue().getNumUnits());
            }
        }));
        Collections.sort(askOrders, new Comparator<Order>(){

            @Override
            public int compare(Order o1, Order o2) {
                return o1.getPrice().getPriceValue().compareTo(o2.getPrice().getPriceValue().getNumUnits());
            }
        });
        for (i = 0; i < bidOrders.size(); ++i) {
            BigDecimal optimumPrice;
            BigDecimal actualPrice = ((Order)bidOrders.get(i)).getPrice().getPriceValue().getNumUnits();
            if (!TradingBot.isDiffTooLarge(actualPrice, optimumPrice = optimumBidPrices[i].getNumUnits())) continue;
            bRet = false;
            break;
        }
        for (i = 0; i < askOrders.size(); ++i) {
            BigDecimal optimumPrice;
            BigDecimal actualPrice = ((Order)askOrders.get(i)).getPrice().getPriceValue().getNumUnits();
            if (!TradingBot.isDiffTooLarge(actualPrice, optimumPrice = optimumAskPrices[i].getNumUnits())) continue;
            bRet = false;
            break;
        }
        return bRet;
    }

    private static boolean isDiffTooLarge(BigDecimal actualPrice, BigDecimal optimumPrice) {
        BigDecimal diff = actualPrice.compareTo(optimumPrice) < 0 ? optimumPrice.subtract(actualPrice) : actualPrice.subtract(optimumPrice);
        return diff.compareTo(optimumPrice.multiply(percentAllowedPriceDeviation)) > 0;
    }

    class Logic
    implements Runnable {
        Logic() {
        }

        @Override
        public void run() {
            block11: {
                try {
                    MtGoxFiatCurrency buyPrice = TradingBot.this.lastTicker.getBuy().getPriceValue();
                    MtGoxFiatCurrency sellPrice = TradingBot.this.lastTicker.getSell().getPriceValue();
                    Order[] openOrders = TradingBot.this.mtgoxAPI.getOpenOrders();
                    MtGoxFiatCurrency[] optimumBidPrices = new MtGoxFiatCurrency[percentagesAboveOrBelowPrice.length];
                    for (int i = 0; i < percentagesAboveOrBelowPrice.length; ++i) {
                        optimumBidPrices[i] = TradingBot.getPriceAtOrderIndex(MtGoxHTTPClient.OrderType.Bid, buyPrice, i);
                    }
                    MtGoxFiatCurrency[] optimumAskPrices = new MtGoxFiatCurrency[percentagesAboveOrBelowPrice.length];
                    for (int i = 0; i < percentagesAboveOrBelowPrice.length; ++i) {
                        optimumAskPrices[i] = TradingBot.getPriceAtOrderIndex(MtGoxHTTPClient.OrderType.Ask, sellPrice, i);
                    }
                    if (TradingBot.isOrdersValid(optimumBidPrices, optimumAskPrices, openOrders)) {
                        logger.info("The current orders remain valid.");
                        break block11;
                    }
                    logger.info("There are invalid bid or ask orders, or none exist.");
                    this.cancelOrders(TradingBot.this.mtgoxAPI, openOrders);
                    AccountInfo info = TradingBot.this.mtgoxAPI.getAccountInfo();
                    Wallet fiatWallet = info.getWallets().get(TradingBot.this.baseCurrency.getCurrency().getCurrencyCode());
                    try {
                        MtGoxBitcoin numBTCtoBuy = new MtGoxBitcoin(fiatWallet.getBalance().divide(buyPrice));
                        logger.log(Level.INFO, "Trying to buy a total of {0} bitcoins.", numBTCtoBuy.toPlainString());
                        for (int i = 0; i < optimumBidPrices.length; ++i) {
                            MtGoxBitcoin vol = new MtGoxBitcoin(numBTCtoBuy.multiply(BigDecimal.valueOf(percentagesOrderPriceSpread[i])));
                            String ref = TradingBot.this.mtgoxAPI.placeOrder(MtGoxHTTPClient.OrderType.Bid, optimumBidPrices[i], vol);
                            logger.log(Level.FINE, "Bid order placed at price: {0}{1} amount: {2} ref: {3}", new Object[]{optimumBidPrices[i].getCurrencyInfo().getCurrency().getCurrencyCode(), optimumBidPrices[i].getNumUnits(), vol.toPlainString(), ref});
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(TradingBot.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    Wallet btcWallet = info.getWallets().get("BTC");
                    try {
                        MtGoxBitcoin numBTCtoSell = (MtGoxBitcoin)btcWallet.getBalance();
                        logger.log(Level.INFO, "Trying to sell a total of {0} bitcoins.", numBTCtoSell.toPlainString());
                        for (int i = 0; i < optimumAskPrices.length; ++i) {
                            MtGoxBitcoin vol = new MtGoxBitcoin(numBTCtoSell.multiply(BigDecimal.valueOf(percentagesOrderPriceSpread[i])));
                            String ref = TradingBot.this.mtgoxAPI.placeOrder(MtGoxHTTPClient.OrderType.Ask, optimumAskPrices[i], vol);
                            logger.log(Level.FINE, "Ask order placed at price: {0}{1} amount: {2} ref: {3}", new Object[]{optimumAskPrices[i].getCurrencyInfo().getCurrency().getCurrencyCode(), optimumAskPrices[i].getNumUnits(), vol.toPlainString(), ref});
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(TradingBot.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    logger.log(Level.INFO, "Account balance: {0} BTC + {2}{3}{1} = Total current value: {2}{3}{4}", new Object[]{btcWallet.getBalance().toPlainString(), fiatWallet.getBalance().toPlainString(), TradingBot.this.lastTicker.getLast().getCurrencyInfo().getCurrency().getCurrencyCode(), TradingBot.this.lastTicker.getLast().getCurrencyInfo().getSymbol(), fiatWallet.getBalance().add(btcWallet.getBalance().multiply(TradingBot.this.lastTicker.getLast().getNumUnits()))});
                }
                catch (Exception ex) {
                    Logger.getLogger(TradingBot.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }

        private void cancelOrders(MtGoxHTTPClient mtGoxAPI, Order[] orders) throws Exception {
            if (ArrayUtils.isNotEmpty(orders)) {
                for (Order order : orders) {
                    logger.log(Level.FINE, "Cancelling order: {0}", order.getOid());
                    mtGoxAPI.cancelOrder(order);
                }
            } else {
                logger.fine("There are no orders to cancel.");
            }
        }
    }
}

