/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.example;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import to.sparks.mtgox.event.DepthEvent;
import to.sparks.mtgox.event.StreamEvent;
import to.sparks.mtgox.event.TickerEvent;
import to.sparks.mtgox.event.TradeEvent;
import to.sparks.mtgox.model.Depth;
import to.sparks.mtgox.model.Ticker;
import to.sparks.mtgox.model.Trade;

public class WebsocketExamples
implements ApplicationListener<StreamEvent> {
    static final Logger logger = Logger.getLogger(WebsocketExamples.class.getName());

    public static void main(String[] args) throws Exception {
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("to/sparks/mtgox/example/WebsocketExamples.xml");
        WebsocketExamples me = context.getBean("websocketExamples", WebsocketExamples.class);
    }

    @Override
    public void onApplicationEvent(StreamEvent event) {
        if (event instanceof DepthEvent) {
            Depth depth = (Depth)event.getPayload();
            logger.log(Level.INFO, "Depth: {0}", new Object[]{depth.getTotalVolume().toPlainString()});
        } else if (event instanceof TickerEvent) {
            Ticker ticker = (Ticker)event.getPayload();
            logger.log(Level.INFO, "Last: {0}", new Object[]{ticker.getLast().toPlainString()});
        } else if (event instanceof TradeEvent) {
            Trade trade = (Trade)event.getPayload();
            logger.log(Level.INFO, "Trade: {0} {1}", new Object[]{trade.getPrice_currency(), trade.getPrice().toPlainString()});
        }
    }
}

