/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Currency;
import to.sparks.mtgox.MtGoxHTTPClient;
import to.sparks.mtgox.model.CurrencyInfo;
import to.sparks.mtgox.model.CurrencyKludge;
import to.sparks.mtgox.model.DtoBase;
import to.sparks.mtgox.model.DynaBean;
import to.sparks.mtgox.model.TickerPrice;

@JsonAutoDetect
public class Order
extends DtoBase
implements CurrencyKludge {
    private String oid;
    private String currency;
    private String item;
    private MtGoxHTTPClient.OrderType type;
    private TickerPrice amount;
    private TickerPrice effective_amount;
    private TickerPrice price;
    private String status;
    private String date;
    private String priority;
    private DynaBean[] actions;
    private TickerPrice invalid_amount;

    public Order(@JsonProperty(value="oid") String oid, @JsonProperty(value="currency") String currency, @JsonProperty(value="item") String item, @JsonProperty(value="type") String type, @JsonProperty(value="amount") TickerPrice amount, @JsonProperty(value="effective_amount") TickerPrice effective_amount, @JsonProperty(value="price") TickerPrice price, @JsonProperty(value="status") String status, @JsonProperty(value="date") String date, @JsonProperty(value="priority") String priority, @JsonProperty(value="actions") DynaBean[] actions, @JsonProperty(value="invalid_amount") TickerPrice invalid_amount) {
        this.oid = oid;
        this.currency = currency;
        this.item = item;
        this.type = type != null && type.equalsIgnoreCase("ask") ? MtGoxHTTPClient.OrderType.Ask : MtGoxHTTPClient.OrderType.Bid;
        this.amount = amount;
        this.effective_amount = effective_amount;
        this.price = price;
        this.status = status;
        this.date = date;
        this.priority = priority;
        this.actions = actions;
        this.invalid_amount = invalid_amount;
        if (this.amount != null) {
            this.amount.setCurrencyInfo(CurrencyInfo.BitcoinCurrencyInfo);
        }
        if (this.effective_amount != null) {
            this.effective_amount.setCurrencyInfo(CurrencyInfo.BitcoinCurrencyInfo);
        }
        if (this.invalid_amount != null) {
            this.invalid_amount.setCurrencyInfo(CurrencyInfo.BitcoinCurrencyInfo);
        }
    }

    public String getOid() {
        return this.oid;
    }

    public Currency getCurrency() {
        return Currency.getInstance(this.currency);
    }

    public String getItem() {
        return this.item;
    }

    public MtGoxHTTPClient.OrderType getType() {
        return this.type;
    }

    public TickerPrice getAmount() {
        return this.amount;
    }

    public TickerPrice getValidAmount() {
        return this.effective_amount;
    }

    public TickerPrice getPrice() {
        return this.price;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDate() {
        return this.date;
    }

    public String getPriority() {
        return this.priority;
    }

    public DynaBean[] getActions() {
        return this.actions;
    }

    public TickerPrice getInvalidAmount() {
        return this.invalid_amount;
    }

    @Override
    public void setCurrencyInfo(CurrencyInfo currencyInfo) {
        this.price.setCurrencyInfo(currencyInfo);
    }
}

