/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import to.sparks.mtgox.model.CurrencyInfo;
import to.sparks.mtgox.model.CurrencyKludge;
import to.sparks.mtgox.model.DtoBase;
import to.sparks.mtgox.model.IEventTime;
import to.sparks.mtgox.model.MtGoxBitcoin;
import to.sparks.mtgox.model.MtGoxFiatCurrency;

@JsonAutoDetect
public class Trade
extends DtoBase
implements IEventTime,
CurrencyKludge {
    private long amount_int;
    private long price_int;
    private long date;
    private String item;
    private String type;
    private String primary;
    private String properties;
    private String tid;
    private String trade_type;
    private CurrencyInfo currencyInfo = null;
    private String price_currency;

    public Trade(@JsonProperty(value="tid") String tid, @JsonProperty(value="primary") String primary, @JsonProperty(value="price_currency") String price_currency, @JsonProperty(value="type") String type, @JsonProperty(value="properties") String properties, @JsonProperty(value="item") String item, @JsonProperty(value="amount") double amount, @JsonProperty(value="price") double price, @JsonProperty(value="trade_type") String trade_type, @JsonProperty(value="date") long date, @JsonProperty(value="amount_int") long amount_int, @JsonProperty(value="price_int") long price_int) {
        this.tid = tid;
        this.primary = primary;
        this.type = type;
        this.properties = properties;
        this.item = item;
        this.trade_type = trade_type;
        this.date = date;
        this.amount_int = amount_int;
        this.price_int = price_int;
        this.price_currency = price_currency;
    }

    public String getTradeId() {
        return this.tid;
    }

    public String getPrimary() {
        return this.primary;
    }

    public String getType() {
        return this.type;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getItem() {
        return this.item;
    }

    public String getTrade_type() {
        return this.trade_type;
    }

    public long getDate() {
        return this.date;
    }

    public MtGoxBitcoin getAmount() {
        MtGoxBitcoin amount = new MtGoxBitcoin(this.amount_int);
        return amount;
    }

    public MtGoxFiatCurrency getPrice() {
        MtGoxFiatCurrency price = null;
        if (this.currencyInfo == null) {
            throw new RuntimeException("Error: getPrice called before currency was initialised.");
        }
        price = new MtGoxFiatCurrency(this.price_int, this.currencyInfo);
        return price;
    }

    @Override
    public long getEventTime() {
        return this.getDate();
    }

    @Override
    public void setCurrencyInfo(CurrencyInfo currencyInfo) {
        this.currencyInfo = currencyInfo;
    }

    public String getPrice_currency() {
        return this.price_currency;
    }
}

