/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import to.sparks.mtgox.model.CurrencyInfo;
import to.sparks.mtgox.model.CurrencyKludge;
import to.sparks.mtgox.model.DtoBase;
import to.sparks.mtgox.model.MtGoxBitcoin;
import to.sparks.mtgox.model.MtGoxFiatCurrency;
import to.sparks.mtgox.model.MtGoxPrice;
import to.sparks.mtgox.model.MtGoxUnitOfCredit;

public class Wallet
extends DtoBase
implements CurrencyKludge {
    private CurrencyInfo currencyInfo;
    private MtGoxPrice balance;
    private long operations;
    private MtGoxPrice dailyWithdrawLimit;
    private MtGoxPrice monthlyWithdrawLimit;
    private MtGoxPrice maxWithdraw;
    private MtGoxPrice openOrders;

    public Wallet(@JsonProperty(value="Balance") MtGoxPrice balance, @JsonProperty(value="Operations") long operations, @JsonProperty(value="Daily_Withdraw_Limit") MtGoxPrice dailyWithdrawLimit, @JsonProperty(value="Monthly_Withdraw_Limit") MtGoxPrice monthlyWithdrawLimit, @JsonProperty(value="Max_Withdraw") MtGoxPrice maxWithdraw, @JsonProperty(value="Open_Orders") MtGoxPrice openOrders) {
        this.balance = balance;
        this.operations = operations;
        this.dailyWithdrawLimit = dailyWithdrawLimit;
        this.monthlyWithdrawLimit = monthlyWithdrawLimit;
        this.maxWithdraw = maxWithdraw;
        this.openOrders = openOrders;
    }

    public CurrencyInfo getCurrencyInfo() {
        return this.currencyInfo;
    }

    @Override
    public void setCurrencyInfo(CurrencyInfo currencyInfo) {
        this.currencyInfo = currencyInfo;
    }

    public MtGoxUnitOfCredit getBalance() {
        MtGoxUnitOfCredit result = new MtGoxBitcoin(this.balance.getPriceValueInt());
        if (this.currencyInfo != null && !this.currencyInfo.isVirtual()) {
            result = new MtGoxFiatCurrency(this.balance.getPriceValueInt(), this.currencyInfo);
        }
        return result;
    }

    public long getOperations() {
        return this.operations;
    }

    public MtGoxPrice getDailyWithdrawLimit() {
        return this.dailyWithdrawLimit;
    }

    public MtGoxPrice getMonthlyWithdrawLimit() {
        return this.monthlyWithdrawLimit;
    }

    public MtGoxPrice getMaxWithdraw() {
        return this.maxWithdraw;
    }

    public MtGoxPrice getOpenOrders() {
        return this.openOrders;
    }
}

