/*
 * Decompiled with CFR 0.152.
 */
package to.sparks.mtgox.service;

import java.io.IOException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Currency;
import java.util.HashMap;
import java.util.logging.Logger;
import to.sparks.mtgox.model.AccountInfo;
import to.sparks.mtgox.model.CurrencyInfo;
import to.sparks.mtgox.model.FullDepth;
import to.sparks.mtgox.model.Lag;
import to.sparks.mtgox.model.Order;
import to.sparks.mtgox.model.OrderResult;
import to.sparks.mtgox.model.Result;
import to.sparks.mtgox.model.SendBitcoinsTransaction;
import to.sparks.mtgox.model.Ticker;
import to.sparks.mtgox.net.HTTPAuthenticator;
import to.sparks.mtgox.net.JSONSource;
import to.sparks.mtgox.service.UrlFactory;

class HTTPClientV1Service
extends HTTPAuthenticator {
    private JSONSource<Result<AccountInfo>> privateInfoJSON;
    private JSONSource<Result<Order[]>> openOrdersJSON = new JSONSource();
    private JSONSource<Result<String>> stringJSON = new JSONSource();
    private JSONSource<Result<OrderResult>> orderResultJSON = new JSONSource();
    private JSONSource<Result<FullDepth>> fullDepthJSON = new JSONSource();
    private JSONSource<Result<Ticker>> tickerJSON = new JSONSource();
    private JSONSource<Result<CurrencyInfo>> currencyInfoJSON;
    private JSONSource<Result<SendBitcoinsTransaction>> sendBitcoinsJSON;
    private JSONSource<Result<Lag>> lagJSON;

    public HTTPClientV1Service(Logger logger, String apiKey, String secret) {
        super(logger, apiKey, secret);
        this.privateInfoJSON = new JSONSource();
        this.currencyInfoJSON = new JSONSource();
        this.sendBitcoinsJSON = new JSONSource();
        this.lagJSON = new JSONSource();
    }

    public FullDepth getFullDepth(Currency currency) throws Exception {
        FullDepth fullDepth = this.fullDepthJSON.getResultFromStream(new URL(UrlFactory.getUrlForRestCommand(currency, UrlFactory.RestCommand.FullDepth)).openStream(), FullDepth.class).getReturn();
        return fullDepth;
    }

    public String placeOrder(Currency currency, HashMap<String, String> params) throws Exception {
        Result<String> result = this.stringJSON.getResultFromStream(this.getMtGoxHTTPInputStream(UrlFactory.getUrlForRestCommand(currency, UrlFactory.RestCommand.PrivateOrderAdd), params), String.class);
        if (result.getError() != null) {
            throw new RuntimeException(result.getToken() + ": " + result.getError());
        }
        return result.getReturn();
    }

    public OrderResult getPrivateOrderResult(HashMap<String, String> params) throws Exception {
        Result<OrderResult> result = this.orderResultJSON.getResultFromStream(this.getMtGoxHTTPInputStream(UrlFactory.getUrlForRestCommand("", UrlFactory.RestCommand.PrivateOrderResult), params), OrderResult.class);
        if (result.getError() != null) {
            throw new RuntimeException(result.getToken() + ": " + result.getError());
        }
        return result.getReturn();
    }

    public Order[] getOpenOrders() throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        Result<Order[]> openOrders = this.openOrdersJSON.getResultFromStream(this.getMtGoxHTTPInputStream(UrlFactory.getUrlForRestCommand("", UrlFactory.RestCommand.PrivateOrders)), Order[].class);
        return openOrders.getReturn();
    }

    public AccountInfo getPrivateInfo() throws IOException, NoSuchAlgorithmException, InvalidKeyException, Exception {
        Result<AccountInfo> privateInfo = this.privateInfoJSON.getResultFromStream(this.getMtGoxHTTPInputStream(UrlFactory.getUrlForRestCommand("", UrlFactory.RestCommand.PrivateInfo)), AccountInfo.class);
        return privateInfo.getReturn();
    }

    public Ticker getTicker(Currency currency) throws IOException, Exception {
        Result<Ticker> tickerUSD = this.tickerJSON.getResultFromStream(this.getMtGoxHTTPInputStream(UrlFactory.getUrlForRestCommand(currency, UrlFactory.RestCommand.Ticker)), Ticker.class);
        return tickerUSD.getReturn();
    }

    public CurrencyInfo getCurrencyInfo(Currency currency) throws IOException, Exception {
        return this.getCurrencyInfo(currency.getCurrencyCode());
    }

    public CurrencyInfo getCurrencyInfo(String currencyCode) throws IOException, Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("currency", currencyCode);
        Result<CurrencyInfo> currencyInfo = this.currencyInfoJSON.getResultFromStream(this.getMtGoxHTTPInputStream(UrlFactory.getUrlForRestCommand(currencyCode, UrlFactory.RestCommand.CurrencyInfo), params), CurrencyInfo.class);
        if (currencyInfo.getError() != null) {
            throw new RuntimeException(currencyInfo.getToken() + ": " + currencyInfo.getError());
        }
        return currencyInfo.getReturn();
    }

    public SendBitcoinsTransaction sendBitcoins(HashMap<String, String> params) throws IOException, Exception {
        Result<SendBitcoinsTransaction> response = this.sendBitcoinsJSON.getResultFromStream(this.getMtGoxHTTPInputStream(UrlFactory.getUrlForRestCommand(UrlFactory.RestCommand.SendBitcoins), params), SendBitcoinsTransaction.class);
        if (response.getError() != null) {
            throw new RuntimeException(response.getToken() + ": " + response.getError());
        }
        return response.getReturn();
    }

    public Lag getLag() throws IOException, Exception {
        Result<Lag> response = this.lagJSON.getResultFromStream(this.getMtGoxHTTPInputStream(UrlFactory.getUrlForRestCommand(UrlFactory.RestCommand.Lag)), Lag.class);
        if (response.getError() != null) {
            throw new RuntimeException(response.getToken() + ": " + response.getError());
        }
        return response.getReturn();
    }
}

