package to.then.jackson.databind.amazonaws;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;


public class AmazonModule extends SimpleModule {
    
    @Override
    public void setupModule(SetupContext context) {
        context.addAbstractTypeResolver(new SimpleAbstractTypeResolver().addMapping(AWSCredentials.class, BasicAWSCredentials.class));
        context.setMixInAnnotations(BasicAWSCredentials.class, BasicAWSCredentialsMixIn.class);
        context.setMixInAnnotations(AmazonWebServiceRequest.class, AmazonWebServiceRequestMixIn.class);
        context.setMixInAnnotations(AmazonWebServiceResponse.class, AmazonWebServiceResponseMixIn.class);
    }
}
